% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{c_}
\alias{c_}
\alias{cheapr_c}
\title{A cheapr version of \code{c()}}
\usage{
c_(..., .args = NULL)

cheapr_c(..., .args = NULL)
}
\arguments{
\item{...}{Objects to combine.}

\item{.args}{An alternative to \code{...} so you can supply arguments directly
in a list. \cr
This is equivalent to \code{do.call(f, .args)} but much more efficient.}
}
\value{
Combined objects.
}
\description{
cheapr's version of \code{c()}. It is quite a bit faster for atomic vectors
and combines data frame rows instead of cols.
}
\examples{
library(cheapr)

# Combine just like `c()`
c_(1, 2, 3:5)

# It combines rows by default instead of cols
c_(new_df(x = 1:3), new_df(x = 4:10))

# If you have a list of objects you want to combine
# use `.args` instead of `do.call` as it's more efficient

list_of_objs <- rep_(list(0), 10^4)

bench::mark(
  do.call(c, list_of_objs),
  do.call(c_, list_of_objs),
  c_(.args = list_of_objs) # Fastest
)

}
