% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tplot.R
\name{tplot}
\alias{tplot}
\title{Plot temporal graph via Latex}
\usage{
tplot(
  x,
  filename = "causaldisco_tplot_temp",
  keepfiles = FALSE,
  bendedges = TRUE,
  ...
)
}
\arguments{
\item{x}{A tamat, tpdag, or tpag object as obtained from \code{\link{tamat}},
\code{\link{tpc}}, or \code{\link{tfci}}, respectively.}

\item{filename}{Name of files that will be used internally during the function's
runtime. This filename will be appended with both .rmd and .pdf.
Note that unless \code{keepfiles = TRUE},
these files will automatically be deleted again.}

\item{keepfiles}{If \code{FALSE} (default), temporary files used for making
the plot are deleted, otherwise they are kept and will be placed in the
working directory.}

\item{bendedges}{If \code{TRUE} (default), all edges are bent 10 degrees
to the right, thereby avoiding edges placed exactly on top of eachother.}

\item{...}{Additional argument passed to \code{\link{maketikz}}.}
}
\description{
Generates a plot of a tamat, tpdag or tpag object by use of Latex tikz. Note
that a working Latex installation is required. Note also that this function
is slower than typical R graphics options and may take some time to terminate.
}
\details{
The function renders Latex code using rmarkdown, which relies on a working
installation of Latex. Afterwards, the resulting pdf graphic is loaded into
R and displayed in a browser. If working in Rstudio it may be opened in the built-in
viewer, depending on Rstudio global settings.
}
