% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{include_card_png}
\alias{include_card_png}
\title{Display card as PNG in knitr/Quarto document}
\usage{
include_card_png(
  svg_string,
  dpi = 300,
  width = "100\%",
  alt = "Card generated by cardargus",
  background = "transparent",
  engine = c("auto", "chrome", "rsvg")
)
}
\arguments{
\item{svg_string}{SVG string from \code{svg_card()}.}

\item{dpi}{Rasterization DPI (default 300).}

\item{width}{Display width (CSS units) for HTML outputs.}

\item{alt}{Alternative text for accessibility.}

\item{background}{Background color passed to \code{svg_to_png()} (default transparent).}

\item{engine}{Rendering engine: \code{"auto"} (uses Chrome if available, else rsvg),
\code{"chrome"} (headless Chrome via chromote), or \code{"rsvg"} (librsvg/magick).
Chrome provides better font rendering for Google Fonts.}
}
\value{
Knitr output for the current format.
}
\description{
Converts an SVG card to PNG and displays it in R Markdown or Quarto documents.
Recommended for better compatibility across HTML/PDF/Word.
}
