% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{printSubset}
\alias{printSubset}
\title{Print Model Selection Information}
\usage{
printSubset(x, ...)
}
\arguments{
\item{x}{Model output from 'bestModel' or a cnorm object.}

\item{...}{Additional parameters.}
}
\value{
Table with model information criteria.
}
\description{
Displays R^2 and other metrics for models with varying predictors, aiding in choosing the best-fitting model
after model fitting.
}
\examples{
# Using cnorm object from sample data
result <- cnorm(raw = elfe$raw, group = elfe$group)
printSubset(result)
}
\seealso{
Other model: 
\code{\link{bestModel}()},
\code{\link{checkConsistency}()},
\code{\link{cnorm.cv}()},
\code{\link{derive}()},
\code{\link{modelSummary}()},
\code{\link{print.cnorm}()},
\code{\link{rangeCheck}()},
\code{\link{regressionFunction}()},
\code{\link{summary.cnorm}()}
}
\concept{model}
