% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.R, R/print-bvharspec.R, R/member.R
\name{set_dl}
\alias{set_dl}
\alias{print.dlspec}
\alias{is.dlspec}
\title{Dirichlet-Laplace Hyperparameter for Coefficients and Contemporaneous Coefficients}
\usage{
set_dl(dir_grid = 100L, shape = 0.01, scale = 0.01)

\method{print}{dlspec}(x, digits = max(3L, getOption("digits") - 3L), ...)

is.dlspec(x)
}
\arguments{
\item{dir_grid}{Griddy gibbs grid size for Dirichlet hyperparameter}

\item{shape}{Inverse Gamma shape}

\item{scale}{Inverse Gamma scale}

\item{x}{Any object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{dlspec} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Set DL hyperparameters for VAR or VHAR coefficient and contemporaneous coefficient.
}
\references{
Bhattacharya, A., Pati, D., Pillai, N. S., & Dunson, D. B. (2015). \emph{Dirichlet-Laplace Priors for Optimal Shrinkage}. Journal of the American Statistical Association, 110(512), 1479-1490.

Korobilis, D., & Shimizu, K. (2022). \emph{Bayesian Approaches to Shrinkage and Sparse Estimation}. Foundations and Trends® in Econometrics, 11(4), 230-354.
}
