% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digital-ocean.R
\name{do_deploy_server}
\alias{do_deploy_server}
\title{Deploy or Update a _server.yml Application}
\usage{
do_deploy_server(
  droplet,
  path,
  local_path,
  port,
  forward = FALSE,
  overwrite = FALSE,
  ...,
  keyfile = do_keyfile(),
  r_packages = NULL
)
}
\arguments{
\item{droplet}{The droplet on which to act. It's expected that this droplet
was provisioned using \code{\link[=do_provision]{do_provision()}}.  See \code{\link[analogsea:droplet]{analogsea::droplet()}} to
obtain a reference to a running droplet.}

\item{path}{The remote path/name of the application}

\item{local_path}{The local directory path containing the \verb{_server.yml} file. The entire directory will be deployed.}

\item{port}{The internal port on which this service should run. This will not
be visible to visitors, but must be unique and point to a port that is available
on your server. If unsure, try a number around \code{8000}.}

\item{forward}{If \code{TRUE}, will setup requests targeting the root URL on the
server to point to this application. See the \code{\link[=do_forward]{do_forward()}} function for
more details.}

\item{overwrite}{if an application is already running for this \code{path} name,
and \code{overwrite = TRUE}, then \code{do_remove_server} will be run.}

\item{...}{additional arguments to pass to \code{\link[analogsea:droplet_ssh]{analogsea::droplet_ssh()}} or
\code{\link[analogsea:droplet_ssh]{analogsea::droplet_upload()}}.
Cannot contain \code{remote}, \code{local}, \code{keyfile} as named arguments.}

\item{keyfile}{Path to private key for authentication. By default, uses the
key for "digitalocean.com" from \code{\link[ssh:ssh_credentials]{ssh::ssh_key_info()}}.}

\item{r_packages}{A character vector of R packages to install via \code{{pak}} on the server. When \code{NULL} (default), all dependencies found via \code{{renv}} will be installed.}
}
\value{
The DigitalOcean droplet
}
\description{
Deploys a _server.yml-based application from your local machine to make it
available on the remote server.
}
