% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_tagesschau.R
\name{tagesschau_search}
\alias{tagesschau_search}
\title{Search Tagesschau content}
\usage{
tagesschau_search(
  search_text = NULL,
  page_size = NULL,
  result_page = NULL,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{search_text}{Query string.}

\item{page_size}{Results per page.}

\item{result_page}{Result page index.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with search results.

Includes \code{date_time} as POSIXct in Europe/Berlin.
}
\description{
Search Tagesschau content
}
\details{
Searches Tagesschau content by free-text query. Official docs:
https://bundesapi.github.io/tagesschau-api/.
}
\examples{
\dontrun{
tagesschau_search(search_text = "energie", page_size = 10, flatten = TRUE)
}

}
\seealso{
\code{\link[=tagesschau_news]{tagesschau_news()}} and \code{\link[=tagesschau_homepage]{tagesschau_homepage()}}.
}
