# Generated by roxytest: do not edit by hand!

# File R/"05-polar.R": @testexamples

test_that("Function br_show_risk_network() @ L31", {
  
  lung <- survival::lung
  # Cox-PH regression
  mod_surv <- br_pipeline(
    data = lung,
    y = c("time", "status"),
    x = c("age", "ph.ecog", "ph.karno"),
    x2 = c("factor(sex)"),
    method = "coxph"
  )
  
  if (requireNamespace("ggnewscale")) {
    p <- br_show_risk_network(mod_surv)
    p
  }
  
  if (requireNamespace("ggnewscale")) {
  assert_s3_class(p, "ggplot")
  }
})


test_that("Function polar_init() @ L219", {
  
  library(ggplot2)
  # -------------------
  #  Init a polar plot
  # -------------------
  
  data <- data.frame(x = LETTERS[1:7])
  
  p1 <- polar_init(data, aes(x = x))
  p1
  
  # Set aes value
  p2 <- polar_init(data, aes(x = x), size = 3, color = "red", alpha = 0.5)
  p2
  
  # Set aes mapping
  set.seed(123L)
  data1 <- data.frame(
    x = LETTERS[1:7],
    shape = c("r", "r", "r", "b", "b", "b", "b"),
    color = c("r", "r", "r", "b", "b", "b", "b"),
    size = abs(rnorm(7))
  )
  # Check https://ggplot2.tidyverse.org/reference/geom_point.html
  # for how to use both stroke and color
  p3 <- polar_init(data1, aes(x = x, size = size, color = color, shape = shape), alpha = 0.5)
  p3
  
  # --------------------
  #  Connect polar dots
  # --------------------
  data2 <- data.frame(
    x1 = LETTERS[1:7],
    x2 = c("B", "C", "D", "E", "C", "A", "C"),
    color = c("r", "r", "r", "b", "b", "b", "b")
  )
  p4 <- p3 + polar_connect(data2, aes(x = x1, xend = x2))
  p4
  
  p5 <- p3 + polar_connect(data2, aes(x = x1, xend = x2, color = color), alpha = 0.8, linetype = 2)
  p5
  
  # Use two different color scales
  if (requireNamespace("ggnewscale")) {
    library(ggnewscale)
    p6 <- p3 +
      new_scale("color") +
      polar_connect(data2, aes(x = x1, xend = x2, color = color), alpha = 0.8, linetype = 2)
    p6 + scale_color_brewer()
    p6 + scale_color_manual(values = c("darkgreen", "magenta"))
  }
  expect_s3_class(p5, "ggplot")
  if (requireNamespace("ggnewscale")) {
    expect_s3_class(p6, "ggplot")
  }
})

