print.replicationSimulator <- function(x, digits = 2, ...) summary(x, digits = digits, ...)

summary.replicationSimulator <- function(object, digits = 2, ...){
  name <- deparse(substitute(x))[[1]]
  if (nchar(name) > 10) name <- "object"
  
  # Check for errors:
  if (all(object$error)) stop(paste0("All simulations resulted in errors:\n",paste(unique(object$errorMessage, collapse = "\n"))))
  
  Exclude <- c("rep", "id", "identical", "correlation", 
               "correlationNonZero", "jaccard", "replicatedEdges", "replicatedZeroes", 
               "strength", "closeness", "betweenness", "error", "errorMessage")
 
  # check number of levels:
  Conditions <- names(object)[!names(object)%in%Exclude]
  
  . <- NULL
  
  fun <- function(x,digits=2){
    paste0(round(mean(x,na.rm=TRUE),digits), " (",round(sd(x,na.rm=TRUE),digits),")")
  }
  
  # Summarize per case:
  df <- object %>% dplyr::select(.data[["correlation"]], 
                                  .data[["correlationNonZero"]], .data[["jaccard"]], .data[["replicatedEdges"]], .data[["replicatedZeroes"]], 
                                  .data[["strength"]], .data[["closeness"]], .data[["betweenness"]], all_of(Conditions)) %>% 
    dplyr::group_by(across(all_of(Conditions))) %>% dplyr::summarize(across(everything(), ~fun(., digits=digits))) %>% 
    dplyr::arrange(.data[['nCases']]) %>% as.data.frame
  # 
 
  
  row.names(df) <- NULL
  
  cat("=== replicationSimulator Results ===\n\n")
  cat("Mean (SD) values per varied levels:\n\n")
  print(df)
  # cat("Standard deviation per varied levels:\n\n")
  # print(dfSD)
  
  
  cat(paste0("\n\nUse plot(",name,") to plot results (nCases only), or as.data.frame(",name,") to see all results."))
  invisible(df)
}

# Plot method

plot.replicationSimulator <- function(x, yvar = c("correlation","jaccard","replicatedEdges","replicatedZeroes"), ...){
  plot.netSimulator(x, yvar = yvar, ...)
}