## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = NA,
  fig.width = 7,
  fig.height = 5
)

## ----setup, message=FALSE-----------------------------------------------------
library(biometryassist)
library(ggplot2)
library(ggspatial)

# Generate a completely randomized design (CRD)
des.out <- design(
  type = "crd", 
  treatments = c(1, 5, 10, 20),
  reps = 5, 
  nrows = 4, 
  ncols = 5, 
  seed = 42
)

## ----north_arrow--------------------------------------------------------------
des.out$plot.des + 
  annotation_north_arrow(
    location = "tr",
    rotation = 53,
    pad_x = unit(-1.5, "cm"),
    pad_y = unit(0.5, "cm"),
    style = north_arrow_fancy_orienteering(
      line_width = 1,
      text_size = 10
    )
  ) +
  coord_cartesian(clip = "off") +
  theme(plot.margin = margin(t = 10, r = 50, b = 10, l = 10, unit = "pt"))

## ----north_arrow_custom, eval=FALSE-------------------------------------------
# des.out$plot.des +
#   annotation_north_arrow(
#     location = "tr",
#     rotation = 30,  # Different rotation angle
#     pad_x = unit(-1, "cm"),
#     pad_y = unit(0.3, "cm"),
#     style = north_arrow_minimal(  # Different style
#       line_width = 1.5,
#       text_size = 12
#     )
#   ) +
#   coord_cartesian(clip = "off") +
#   theme(plot.margin = margin(t = 10, r = 50, b = 10, l = 10, unit = "pt"))

## ----field_annotations--------------------------------------------------------
des.out$plot.des + 
  annotate(
    "text",
    x = 5.8,
    y = mean(des.out$design$row),
    label = "Boundary Road",
    angle = 270,
    hjust = 0.5,
    vjust = -0.5,
    size = 6
  ) +
  annotate(
    "text",
    x = 1.5,
    y = 5,
    label = "Gate",
    hjust = 0.5,
    vjust = -0.5,
    size = 6
  ) +
  coord_cartesian(xlim = c(0.5, 5.5), ylim = c(0.5, 4.5), clip = "off") +
  theme(plot.margin = margin(t = 10, r = 70, b = 20, l = 10, unit = "pt"),
        legend.position="none")

## ----multiple_annotations, eval=TRUE------------------------------------------
des.out$plot.des + 
  annotate("text", x = 5.8, y = mean(des.out$design$row), 
           label = "Boundary Road", angle = 270, hjust = 0.5, vjust = -0.5, size = 6) +
  annotate("text", x = 1.5, y = 5, 
           label = "Gate", hjust = 0.5, vjust = -0.5, size = 6) +
  annotate("text", x = 0.2, y = mean(des.out$design$row), 
           label = "Irrigation Line", angle = 90, hjust = 0.5, vjust = -0.5, size = 5) +
  annotate("text", x = mean(des.out$design$col), y = 0.2, 
           label = "Drainage Ditch", hjust = 0.5, vjust = 1, size = 5) +
  coord_cartesian(xlim = c(0.5, 5.5), ylim = c(0.5, 4.5), clip = "off") +
  theme(plot.margin = margin(t = 20, r = 70, b = 30, l = 50, unit = "pt"),
        legend.position="none")

## ----combined_example---------------------------------------------------------
des.out$plot.des + 
  # Add north arrow
  annotation_north_arrow(
    location = "tr",
    rotation = 45,
    pad_x = unit(-1.5, "cm"),
    pad_y = unit(0.5, "cm"),
    style = north_arrow_fancy_orienteering(line_width = 1, text_size = 10)
  ) +
  # Add field feature annotations
  annotate("text", x = 5.8, y = mean(des.out$design$row), 
           label = "Boundary Road", angle = 270, hjust = 0.5, vjust = -0.5, size = 6) +
  annotate("text", x = 1.5, y = 5, 
           label = "Gate", hjust = 0.5, vjust = -0.5, size = 6) +
  # Apply coordinate system and theme adjustments
  coord_cartesian(xlim = c(0.5, 5.5), ylim = c(0.5, 4.5), clip = "off") +
  theme(plot.margin = margin(t = 20, r = 70, b = 20, l = 10, unit = "pt"),
        legend.position="none")

## ----rcbd_example-------------------------------------------------------------
# Generate an RCBD
des.rcbd <- design(
  type = "rcbd",
  treatments = LETTERS[1:6],
  reps = 4,
  nrows = 6,
  ncols = 4,
  brows = 6,
  bcols = 1,
  seed = 123
)

# Add annotations
des.rcbd$plot.des +
  annotation_north_arrow(
    location = "tr",
    rotation = 0,
    pad_x = unit(-1, "cm"),
    pad_y = unit(0.5, "cm"),
    style = north_arrow_minimal(line_width = 1, text_size = 10)
  ) +
  annotate("text", x = 4.8, y = mean(des.rcbd$design$row),
           label = "Access Road", angle = 270, hjust = 0.5, vjust = -0.5, size = 5) +
  coord_cartesian(xlim = c(0.5, 4.5), ylim = c(0.5, 6.5), clip = "off") +
  theme(plot.margin = margin(t = 10, r = 60, b = 10, l = 10, unit = "pt"))

