% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_translocations.R
\name{calculate_genome_factor}
\alias{calculate_genome_factor}
\title{Calculate genomic conversion factor}
\usage{
calculate_genome_factor(dna_table, chromosomes, colors, sex)
}
\arguments{
\item{dna_table}{DNA content fractions table. Can be \code{dna_content_fractions_morton} or \code{dna_content_table_ihgsc}.}

\item{chromosomes}{Vector of stained chromosomes.}

\item{colors}{Vector of colors of the stains.}

\item{sex}{Sex of the individual.}
}
\value{
Numeric value of genomic conversion factor.
}
\description{
Method based on the paper by Lucas, J. N. et al. (1992). Rapid Translocation
Frequency Analysis in Humans Decades after Exposure to Ionizing Radiation.
International Journal of Radiation Biology, 62(1), 53-63.
<doi:10.1080/09553009214551821>.
}
\examples{
#dna_table can be: dna_content_fractions_morton OR dna_content_fractions_ihgsc

calculate_genome_factor(
  dna_table = dna_content_fractions_morton,
  chromosome = c(1, 2, 3, 4, 5, 6),
  color = c("Red", "Red", "Green", "Red", "Green", "Green"),
  sex = "male"
)
}
