% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{print.summary.brsmm}
\alias{print.summary.brsmm}
\title{Print summary for brsmm models}
\usage{
\method{print}{summary.brsmm}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{A \code{"summary.brsmm"} object.}

\item{digits}{Number of digits.}

\item{...}{Passed to \code{printCoefmat}.}
}
\value{
Invisibly returns \code{x}.
}
\description{
Print summary for brsmm models
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
print(summary(fit))
}

}
\seealso{
\code{\link{summary.brsmm}}, \code{\link{brsmm}},
  \code{\link{print.brsmm}}
}
