% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{fitted.brsmm}
\alias{fitted.brsmm}
\title{Fitted values from a brsmm model}
\usage{
\method{fitted}{brsmm}(object, type = c("mu", "phi"), ...)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{type}{Character: \code{"mu"} (default) or \code{"phi"}.}

\item{...}{Currently ignored.}
}
\value{
Numeric vector.
}
\description{
Fitted values from a brsmm model
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
head(fitted(fit))
head(fitted(fit, type = "phi"))
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{residuals.brsmm}},
  \code{\link{predict.brsmm}}
}
