% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audrex.R, R/main.R
\docType{package}
\name{audrex}
\alias{audrex-package}
\alias{audrex}
\title{audrex: Automatic Dynamic Regression using Extreme Gradient Boosting}
\usage{
audrex(
  data,
  n_sample = 10,
  n_search = 5,
  smoother = FALSE,
  seq_len = NULL,
  diff_threshold = 0.001,
  booster = "gbtree",
  norm = NULL,
  n_dim = NULL,
  ci = 0.8,
  min_set = 30,
  max_depth = NULL,
  eta = NULL,
  gamma = NULL,
  min_child_weight = NULL,
  subsample = NULL,
  colsample_bytree = NULL,
  lambda = NULL,
  alpha = NULL,
  n_windows = 3,
  patience = 0.1,
  nrounds = 100,
  dates = NULL,
  acq = "ucb",
  kappa = 2.576,
  eps = 0,
  kernel = list(type = "exponential", power = 2),
  seed = 42
)
}
\arguments{
\item{data}{A data frame with time features on columns.}

\item{n_sample}{Positive integer. Number of samples for the Bayesian Optimization. Default: 10.}

\item{n_search}{Positive integer. Number of search steps for the Bayesian Optimization. When the parameter is set to 0, optimization is shifted to Random Search. Default: 5,}

\item{smoother}{Logical. Perform optimal smoothing using standard loess. Default: FALSE}

\item{seq_len}{Positive integer. Number of time-steps to be predicted. Default: NULL (automatic selection)}

\item{diff_threshold}{Positive numeric. Minimum F-test threshold for differentiating each time feature (keep it low). Default: 0.001.}

\item{booster}{String. Optimization methods available are: "gbtree", "gblinear". Default: "gbtree".}

\item{norm}{Logical. Boolean flag to apply Yeo-Johson normalization. Default: NULL (automatic selection from random search or bayesian search).}

\item{n_dim}{Positive integer. Projection of time features in a lower dimensional space with n_dim features. The default value (NULL) sets automatically the values in c(1, n features).}

\item{ci}{Confidence interval. Default: 0.8.}

\item{min_set}{Positive integer. Minimun number for validation set in case of automatic resize of past dimension. Default: 30.}

\item{max_depth}{Positive integer. Look to xgboost documentation for description. A vector with one or two positive integer for the search boundaries. The default value (NULL) sets automatically the values in c(1, 8).}

\item{eta}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric between (0, 1] for the search boundaries. The default value (NULL) sets automatically the values in c(0, 1).}

\item{gamma}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric for the search boundaries. The default value (NULL) sets automatically the values in c(0, 100).}

\item{min_child_weight}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric for the search boundaries. The default value (NULL) sets automatically the values in c(0, 100).}

\item{subsample}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric between (0, 1] for the search boundaries. The default value (NULL) sets automatically the values in c(0, 1).}

\item{colsample_bytree}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric between (0, 1] for the search boundaries. The default value (NULL) sets automatically the values in c(0, 1).}

\item{lambda}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric for the search boundaries. The default value (NULL) sets automatically the values in c(0, 100).}

\item{alpha}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric for the search boundaries. The default value (NULL) sets automatically the values in c(0, 100).}

\item{n_windows}{Positive integer. Number of (expanding) windows for cross-validation. Default: 3.}

\item{patience}{Positive numeric. Percentage of waiting rounds without improvement before xgboost stops. Default: 0.1}

\item{nrounds}{Positive numeric. Number of round for the extreme boosting machine. Look to xgboost for description. Default: 100.}

\item{dates}{Date. Vector of dates for the time series. Default: NULL (progressive numbers).}

\item{acq}{String. Parameter for Bayesian Optimization. For reference see rBayesianOptimization documentation. Default: "ucb".}

\item{kappa}{Positive numeric. Parameter for Bayesian Optimization. For reference see rBayesianOptimization documentation. Default: 2.576.}

\item{eps}{Positive numeric. Parameter for Bayesian Optimization. For reference see rBayesianOptimization documentation. Default: 0.}

\item{kernel}{List. Parameter for Bayesian Optimization. For reference see rBayesianOptimization documentation. Default: list(type = "exponential", power = 2).}

\item{seed}{Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item history: a table with the models from bayesian (n_sample + n_search) or random search (n_sample), their hyper-parameters and optimization metric, the weighted average rank
\item models: a list with the details for each model in history
\item best_model: results for the best selected model according to the weighted average rank, including:
\itemize{
\item predictions: min, max, q25, q50, q75, quantile at selected ci, mean, sd, skewness and kurtosis for each time feature
\item joint_error: max sequence error for the differentiated time features (max_rmse, max_mae, max_mdae, max_mape, max_mase, max_rae, max_rse, max_rrse, both for training and testing)
\item serie_errors: sequence error for the differentiated time features averaged across testing windows (rmse, mae, mdae, mape, mase, rae, rse, rrse, both for training and testing)
\item pred_stats: for each predicted time feature, IQR to range, divergence, risk ratio, upside probability, averaged across prediction time-points and at the terminal points
\item plots: a plot for each predicted time feature with highlighted median and confidence intervals
}
\item time_log
}
}
\description{
Dynamic regression for time series using Extreme Gradient Boosting with hyper-parameter tuning via Bayesian Optimization or Random Search.
}
\examples{
\donttest{
audrex(covid_in_europe[, 2:5], n_samp = 3, n_search = 2, seq_len = 10) ### BAYESIAN OPTIMIZATION
audrex(covid_in_europe[, 2:5], n_samp = 5, n_search = 0, seq_len = 10) ### RANDOM SEARCH
}


}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/audrex}
}

}
\author{
\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]


Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
