% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{astro_ecliptic}
\alias{astro_ecliptic}
\title{Convert J2000 equatorial coordinates to ecliptic coordinates}
\usage{
astro_ecliptic(x, y, z, time)
}
\arguments{
\item{x}{X coordinate in AU.}

\item{y}{Y coordinate in AU.}

\item{z}{Z coordinate in AU.}

\item{time}{A POSIXct time value.}
}
\value{
A list with elements:
\describe{
\item{x}{X coordinate (Cartesian) in ecliptic frame in AU.}
\item{y}{Y coordinate (Cartesian) in ecliptic frame in AU.}
\item{z}{Z coordinate (Cartesian) in ecliptic frame in AU.}
\item{lon}{Ecliptic longitude in degrees.}
\item{lat}{Ecliptic latitude in degrees.}
\item{dist}{Distance in AU.}
\item{time}{Observation time as POSIXct.}
}
}
\description{
Converts equatorial coordinates in the J2000 frame (mean equator of Earth at noon UTC
on 1 January 2000) to true ecliptic coordinates of date (relative to the plane of
Earth's orbit on the given date).
}
\examples{
time <- as.POSIXct("2025-02-19 22:10:12", tz = "UTC")
astro_ecliptic(1.0, 0.5, 0.2, time)
}
