% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_camtrapR}
\alias{export_camtrapR}
\title{Export data into sorted folders organized by station}
\usage{
export_camtrapR(
  manifest,
  out_dir,
  out_file = NULL,
  label_col = "prediction",
  file_col = "filepath",
  station_col = "station",
  unique_name = "uniquename",
  copy = FALSE
)
}
\arguments{
\item{manifest}{dataframe containing images and associated predictions}

\item{out_dir}{directory to export sorted images}

\item{out_file}{if provided, save the manifest to this file}

\item{label_col}{column containing species labels}

\item{file_col}{column containing source paths}

\item{station_col}{column containing station names}

\item{unique_name}{column containing unique file name}

\item{copy}{if true, hard copy}
}
\value{
manifest with link column
}
\description{
Export data into sorted folders organized by station
}
\examples{
\dontrun{manifest <- export_camtrapR(manifest, out_dir, out_file=NULL, label_col='prediction',
                                     file_col="filepath", station_col='station', 
                                     unique_name='uniquename', copy=FALSE)}
}
