% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{vcov.mixture}
\alias{vcov.mixture}
\title{Variance of a mixture distribution.}
\usage{
\method{vcov}{mixture}(object, ...)
}
\arguments{
\item{object}{A \code{mixture} object.}

\item{...}{Additional arguments (not used).}
}
\value{
The variance (scalar for univariate mixtures).
}
\description{
Uses the law of total variance:
\eqn{Var(X) = E[Var(X|K)] + Var(E[X|K])}.
}
\examples{
m <- mixture(list(normal(0, 1), normal(10, 1)), c(0.5, 0.5))
vcov(m)
}
