% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edist.R
\name{+.dist}
\alias{+.dist}
\title{Method for adding \code{dist} objects, or shifting a distribution by a scalar.}
\usage{
\method{+}{dist}(x, y)
}
\arguments{
\item{x}{A \code{dist} object or numeric scalar}

\item{y}{A \code{dist} object or numeric scalar}
}
\value{
A simplified distribution or \code{edist} if no closed form exists
}
\description{
Creates an expression distribution and automatically simplifies to
closed form when possible (e.g., normal + normal = normal,
normal + scalar = normal with shifted mean).
}
\examples{
# Sum of two normals simplifies to a normal
z <- normal(0, 1) + normal(2, 3)
z  # Normal(mu = 2, var = 4)

# Shift a distribution by a constant
normal(0, 1) + 5  # Normal(mu = 5, var = 1)
}
