% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_dist.R
\name{density.weibull_dist}
\alias{density.weibull_dist}
\title{Probability density function for a Weibull distribution.}
\usage{
\method{density}{weibull_dist}(x, ...)
}
\arguments{
\item{x}{A \code{weibull_dist} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(t, log = FALSE, ...)} returning the
density (or log-density) at \code{t}.
}
\description{
Returns a function that evaluates the Weibull PDF at given points.
}
\examples{
x <- weibull_dist(shape = 2, scale = 3)
f <- density(x)
f(1)
f(3)
}
