% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvn.R
\name{conditional.mvn}
\alias{conditional.mvn}
\title{Conditional distribution for multivariate normal.}
\usage{
\method{conditional}{mvn}(x, P = NULL, ..., given_indices = NULL, given_values = NULL)
}
\arguments{
\item{x}{An \code{mvn} object.}

\item{P}{Optional predicate function for MC fallback.}

\item{...}{Additional arguments forwarded to the predicate \code{P}.}

\item{given_indices}{Integer vector of observed variable indices.}

\item{given_values}{Numeric vector of observed values (same length as
\code{given_indices}).}
}
\value{
A \code{normal}, \code{mvn}, or \code{empirical_dist} object.
}
\description{
Supports two calling patterns:
\enumerate{
\item \strong{Closed-form} (via \code{given_indices} and
\code{given_values}): Uses the exact Schur complement formula.
Returns a \code{normal} (1D result) or \code{mvn}.
\item \strong{Predicate-based} (via \code{P}): Falls back to MC
realization via \code{\link{ensure_realized}}.
}
}
\examples{
# Closed-form conditioning: X2 | X1 = 1
sigma <- matrix(c(1, 0.5, 0.5, 1), 2, 2)
X <- mvn(c(0, 0), sigma)
X2_given <- conditional(X, given_indices = 1, given_values = 1)
mean(X2_given)
vcov(X2_given)

# Predicate-based MC fallback (slower)
\donttest{
set.seed(42)
X2_mc <- conditional(X, P = function(x) x[1] > 0)
}
}
