% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_set_values_to.R
\name{process_set_values_to}
\alias{process_set_values_to}
\title{Process \code{set_values_to} Argument}
\usage{
process_set_values_to(dataset, set_values_to = NULL, expected_types = NULL)
}
\arguments{
\item{dataset}{Input dataset

\describe{
\item{Default value}{none}
}}

\item{set_values_to}{Variables to set

A named list returned by \code{exprs()} defining the variables to be set, e.g.
\code{exprs(PARAMCD = "OS", PARAM = "Overall Survival")} is expected. The values
must be symbols, character strings, numeric values, expressions, or \code{NA}.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{expected_types}{If the argument is specified, the specified variables are checked whether
the specified type matches the type of the variables created by
\code{set_values_to}.

\describe{
\item{Permitted values}{A character vector with values \code{"numeric"} or \code{"character"}}
\item{Default value}{\code{NULL}}
}}
}
\value{
The input dataset with the variables specified by \code{set_values_to}
added/updated
}
\description{
The function creates the variables specified by the \code{set_values_to} argument,
catches errors, provides user friendly error messages, and optionally checks
the type of the created variables.
}
\examples{
library(dplyr)
data <- tribble(
  ~AVAL,
  20
)

try(
  process_set_values_to(
    data,
    set_values_to = exprs(
      PARAMCD = BMI
    )
  )
)

try(
  process_set_values_to(
    data,
    set_values_to = exprs(
      PARAMCD = 42
    ),
    expected_types = c(PARAMCD = "character")
  )
)
}
\concept{utils_help}
\keyword{utils_help}
