% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R, R/printFunctions.R
\name{predict.buhlmannStraubGLM}
\alias{predict.buhlmannStraubGLM}
\alias{buhlmannStraubGLM-class}
\alias{print.buhlmannStraubGLM}
\alias{summary.buhlmannStraubGLM}
\alias{fitted.buhlmannStraubGLM}
\title{Class "buhlmannStraubGLM" of fitted Buhlmann-Straub GLM credibility models}
\usage{
\method{predict}{buhlmannStraubGLM}(object, newdata = NULL, ...)

\method{print}{buhlmannStraubGLM}(x, ...)

\method{summary}{buhlmannStraubGLM}(object, ...)

\method{fitted}{buhlmannStraubGLM}(object, ...)
}
\arguments{
\item{object}{an object of class \code{\link{buhlmannStraubGLM}}}

\item{newdata}{optionally, a data frame in which to look for variables with which to predict.}

\item{...}{currently ignored.}

\item{x}{an object of class \code{\link{buhlmannStraubGLM}}}
}
\value{
The function \code{\link{buhlmannStraubGLM}} returns an object of class \code{buhlmannStraubGLM}, which has the following slots:

\item{call}{the matched call}

\item{CredibilityResults}{results of the Buhlmann-Straub credibility model.}

\item{fitGLM}{the results from fitting the GLM part.}

\item{iter}{total number of iterations.}

\item{Converged}{logical indicating whether the algorithm converged.}

\item{LevelsCov}{object that summarizes the unique levels of each of the contract-specific covariates.}

\item{fitted.values}{the fitted mean values, resulting from the model fit.}

\item{prior.weights}{the weights (exposure) initially supplied.}

\item{y}{if requested, the response vector.}
}
\description{
Class "buhlmannStraubGLM" of fitted Buhlmann-Straub GLM credibility models
}
\section{{S3 methods}}{

\describe{
 \item{\code{print}:}{Prints the \code{call}, convergence status, number of iterations, and GLM summary.
  The \code{...} argument is currently ignored. Returns an invisible copy of the original object.}
 \item{\code{summary}:}{In addition to the output of the \code{print.buhlmannStraubGLM} function, the \code{summary} function
  prints the credibility results and random effect estimates as well. Returns an invisible copy of the original object.}
  \item{\code{fitted}:}{Returns the fitted values.}
  \item{\code{predict}:}{Predict method for new data.}
  \item{\code{ranef}:}{Returns the random effects (cluster relativities).}
  \item{\code{fixef}:}{Returns the fixed effects coefficients.}
  \item{\code{weights}:}{Returns either credibility weights or exposure weights.}
}
}

\seealso{
\code{\link{buhlmannStraubGLM}}
}
