\name{getNBTX}
\alias{getNBTX}

\title{
Get the data of the crypto currency from NOBITEX
}
\description{
Download the history data of the crypto currencies from the Nobitex (website of "nobitex.ir").
}
\usage{
getNBTX(src,frame,from,to)
}

\arguments{
  \item{src}{
  List of the some crypto curencies which available in the function.\cr
BTCIRT, ETHIRT, LTCIRT, USDTIRT, XRPIRT, BCHIRT, BNBIRT, EOSIRT, XLMIRT, ETCIRT, TRXIRT, DOGEIRT, UNIIRT, DAIIRT, LINKIRT, DOTIRT, AAVEIRT, ADAIRT, SHIBIRT, FTMIRT, MATICIRT, AXSIRT, MANAIRT, SANDIRT, AVAXIRT, MKRIRT, GMTIRT, USDCIRT, BTCUSDT, ETHUSDT, LTCUSDT, XRPUSDT, BCHUSDT, BNBUSDT, EOSUSDT, XLMUSDT, ETCUSDT, TRXUSDT, PMNUSDT, DOGEUSDT, UNIUSDT, DAIUSDT, LINKUSDT, DOTUSDT, AAVEUSDT, ADAUSDT, SHIBUSDT, FTMUSDT, MATICUSDT, AXSUSDT, MANAUSDT, SANDUSDT, AVAXUSDT, MKRUSDT, GMTUSDT, USDCUSDT, CHZIRT, GRTIRT, CRVIRT, BANDUSDT, COMPUSDT, EGLDIRT, HBARUSDT, GALIRT, HBARIRT, WBTCUSDT, IMXIRT, WBTCIRT, ONEIRT, GLMUSDT, ENSIRT, 1M_BTTIRT, SUSHIIRT, LDOIRT, ATOMUSDT, ZROIRT, STORJIRT, ANTIRT, AEVOUSDT, 100K_FLOKIIRT, RSRUSDT, API3USDT, GLMIRT, XMRIRT, ENSUSDT, OMIRT, RDNTIRT, MAGICUSDT, TIRT, ATOMIRT, NOTIRT, CVXIRT, XTZIRT, FILIRT, UMAIRT, 1B_BABYDOGEIRT, BANDIRT, SSVIRT, DAOIRT, BLURIRT, ONEUSDT, EGALAUSDT, GMXIRT, XTZUSDT, FLOWUSDT, GALUSDT, WIRT, CVCUSDT, NMRUSDT, SKLIRT, SNTIRT, BATUSDT, TRBUSDT, NMRIRT, RDNTUSDT, API3IRT, CVCIRT, WLDIRT, YFIUSDT, SOLIRT, TUSDT, QNTUSDT, IMXUSDT, AEVOIRT, GMXUSDT, ETHFIUSDT, QNTIRT, GRTUSDT, WLDUSDT, FETIRT, AGIXIRT, NOTUSDT, LPTIRT, SLPIRT, MEMEUSDT, SOLUSDT, BALUSDT, DAOUSDT, COMPIRT, MEMEIRT, TONUSDT, BATIRT, SNXIRT, TRBIRT, 1INCHUSDT, OMUSDT, RSRIRT, RNDRIRT, SLPUSDT, SSVUSDT, RNDRUSDT, AGLDIRT, NEARUSDT, WOOUSDT, YFIIRT, MDTIRT, CRVUSDT, MDTUSDT, EGLDUSDT, LRCIRT, LPTUSDT, BICOUSDT, 1M_PEPEIRT, BICOIRT, MAGICIRT, ETHFIIRT, ANTUSDT, 1INCHIRT, APEUSDT, 1M_NFTIRT, ARBIRT, LRCUSDT, WUSDT, BLURUSDT, CELRUSDT, DYDXIRT, CVXUSDT, BALIRT, TONIRT, 100K_FLOKIUSDT, JSTUSDT, ZROUSDT, ARBUSDT, APTIRT, 1M_NFTUSDT, CELRIRT, UMAUSDT, SKLUSDT, ZRXUSDT, AGLDUSDT, ALGOIRT, NEARIRT, APTUSDT, ZRXIRT, SUSHIUSDT, FETUSDT, ALGOUSDT, 1M_PEPEUSDT, MASKIRT, EGALAIRT, FLOWIRT, 1B_BABYDOGEUSDT, MASKUSDT, 1M_BTTUSDT, STORJUSDT, XMRUSDT, OMGIRT, SNTUSDT, APEIRT, FILUSDT, ENJUSDT, OMGUSDT, WOOIRT, CHZUSDT, ENJIRT, DYDXUSDT, AGIXUSDT, JSTIRT, LDOUSDT, SNXUSDT

}
  \item{frame}{
A character value shows the data frame. The frame is defined as\cr
"1" is one minute. \cr
"5" is 5 minutes.\cr
"15" is 15 minutes. \cr
"30" is 30 minutes. \cr
"60" is an hour.\cr
"180" is three hours.\cr
"240" is four hours.\cr
"360" is six hours.\cr
"720" is twelve hours.\cr
"D" is a day.\cr
"2D" is two days.\cr
"3D" is three days. \cr
}
  \item{from}{
  "2025-12-23 13:13:57 +0330"
The character string in the date format ("\%Y-\%m-\%d \%H:\%M:\%S") shows the start date of the time frame. Since, the data is time series format, the rules of \code{POSIXct} satisfied.
}
  \item{to}{
The character string in the date format ("\%Y-\%m-\%d \%H:\%M:\%S") shows the end date of the time frame. Since, the data is time series format, the rules of \code{POSIXct} satisfied.
}
}
\details{
	A symbol of the crypto currency can be named and the values will be assigned the variable. Component data is an array with \CRANpkg{xts} time series object. The names for dimensions are: Open, High, Low, Close, Volume. The value of symbol are appear in \code{Global Environment}.
}
\value{
	The output is an object of the \dQuote{cryto currency} assigned the variable's name.
}


\examples{
\dontrun{
# Download daily data from last one month
x <- getNBTX("BTCUSDT", frame = "D", from = paste0(Sys.Date()-30, substr(Sys.time(), 11, 19))
                                  , to=Sys.time())

}
}
