orderBook<-function(src){
  sc <-  paste0('https://apiv2.nobitex.ir/v3/orderbook/',src)
  res <- fromJSON(paste(readLines(sc,warn=FALSE), collapse=""))
  
  ask<-do.call(rbind,res$ask)
  bid<-do.call(rbind,res$bid)
  
  orderbook<-cbind(ask,bid,res$lastTradePrice)
  orderbook<-apply(orderbook, 2, as.numeric)
  colnames(orderbook)<-c("prc.ask","vol.ask","prc.bid","vol.bid","lst.prc")
  return(as.data.frame(orderbook))
}