% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WVIM.R
\name{WVIM}
\alias{WVIM}
\title{Williamson's Variable Importance Measure (WVIM)}
\description{
Base class generalizing refit-based variable importance measures.
Default corresponds to leaving out each feature \code{n_repeats} times, which
corresponds to LOCO (Leave One Covariate Out).
}
\examples{
\dontshow{if (requireNamespace("ranger", quietly = TRUE) && requireNamespace("mlr3learners", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(mlr3)
library(mlr3learners)

task <- sim_dgp_correlated(n = 500)

# Group correlated features together, independent features separately
groups <- list(
  correlated = c("x1", "x2"),
  independent = c("x3", "x4")
)

wvim <- WVIM$new(
  task = task,
  learner = lrn("regr.ranger", num.trees = 10),
  groups = groups
)
wvim$compute()
wvim$importance()
\dontshow{\}) # examplesIf}
}
\keyword{internal}
\section{Super class}{
\code{\link[xplainfi:FeatureImportanceMethod]{xplainfi::FeatureImportanceMethod}} -> \code{WVIM}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{direction}}{(\code{character(1)}) Either "leave-out" or "leave-in".}

\item{\code{design}}{(\code{logical()}) Feature selection design matrix where \code{TRUE} equals "left in" and \code{FALSE} "left out".
Columns correspond to \code{task$feature_names} and the number of rows corresponds to \code{length(features) * n_repeats}.
The base matrix is created by \link{wvim_design_matrix} and then replicated \code{n_repeats} times before.}

\item{\code{instance}}{(\code{FSelectInstanceBatchSingleCrit}) The \code{mlr3fselect} feature selection instance containing
also the archive of all evaluations, possible useful for future use. Only stored if \code{store_instance} is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WVIM-new}{\code{WVIM$new()}}
\item \href{#method-WVIM-compute}{\code{WVIM$compute()}}
\item \href{#method-WVIM-clone}{\code{WVIM$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="importance"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-importance'><code>xplainfi::FeatureImportanceMethod$importance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="obs_loss"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-obs_loss'><code>xplainfi::FeatureImportanceMethod$obs_loss()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="print"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-print'><code>xplainfi::FeatureImportanceMethod$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="reset"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-reset'><code>xplainfi::FeatureImportanceMethod$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="scores"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-scores'><code>xplainfi::FeatureImportanceMethod$scores()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WVIM-new"></a>}}
\if{latex}{\out{\hypertarget{method-WVIM-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WVIM$new(
  task,
  learner,
  measure = NULL,
  resampling = NULL,
  features = NULL,
  groups = NULL,
  direction = c("leave-out", "leave-in"),
  label = "Williamson's Variable Importance Measure (WVIM)",
  n_repeats = 1L
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task, learner, measure, resampling, features, groups}}{Passed to \code{FeatureImportanceMethod} for construction.}

\item{\code{direction}}{(\code{character(1)}) Either "leave-out" or "leave-in".}

\item{\code{label}}{(\code{character(1)}) Method label.}

\item{\code{n_repeats}}{(\code{integer(1)}) Number of refit iterations per resampling iteration.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WVIM-compute"></a>}}
\if{latex}{\out{\hypertarget{method-WVIM-compute}{}}}
\subsection{Method \code{compute()}}{
Computes leave-out or leave-in feature importance.
\code{wvim_design_matrix(task$feature_names, "leave-out")} corresponds to LOCO.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WVIM$compute(
  store_models = TRUE,
  store_backends = TRUE,
  store_instance = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{store_models, store_backends}}{(\code{logical(1)}: \code{TRUE}) Whether to store fitted models / data backends, passed to \link[mlr3:resample]{mlr3::resample} internally
backends in resample result.
Required for some measures, but may increase memory footprint.}

\item{\code{store_instance}}{(\code{logical(1)}: \code{FALSE}) Whether to store the \link[mlr3fselect:mlr3fselect-package]{mlr3fselect::mlr3fselect} instance in \verb{$instance}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WVIM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WVIM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WVIM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
