% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtweedie_inversion.R
\name{dtweedie_inversion}
\alias{dtweedie_inversion}
\alias{dtweedie.inversion}
\title{Fourier Inversion Evaluation for the Tweedie Probability Function}
\usage{
dtweedie_inversion(y, mu, phi, power, method = 3, verbose = FALSE, 
                          details = FALSE, IGexact = TRUE)

dtweedie.inversion(y, power, mu, phi, method = 3, verbose, details)
}
\arguments{
\item{y}{vector of quantiles.}

\item{mu}{the mean parameter \eqn{\mu}{mu}.}

\item{phi}{the dispersion parameter \eqn{\phi}{phi}.}

\item{power}{scalar; the power parameter \eqn{p}{power}.}

\item{method}{the method to use; one of \code{1}, \code{2}, or \code{3} (the default).}

\item{verbose}{logical; if \code{TRUE}, display some internal computation details. The default is \code{FALSE}.}

\item{details}{logical; if \code{TRUE}, return a list with basic details of the integration. The default is \code{FALSE}.}

\item{IGexact}{logical; if \code{TRUE} (the default), evaluate the inverse Gaussian distribution using the 'exact' values, otherwise uses inversion.}
}
\value{
A numeric vector of densities if \code{details=FALSE}; if \code{details = TRUE}, a list containing \code{denisty} (a vector of the values of the density), \code{regions} (a vector of the number of integration regions used),\code{method} (a vector giving the evaluation method used; see the Note below on the three methods), and \code{exitstatus} (a vector, where a \code{1} for any value means a computational problem or target relative accuracy not reached, for the corresponding observation).
}
\description{
Evaluates the probability density function (\acronym{pdf}) for Tweedie distributions using Fourier inversion, 
for given values of the dependent variable \code{y}, the mean \code{mu}, dispersion \code{phi}, and power parameter \code{power}.
\emph{Not usually called by general users}, but can be used in the case of evaluation problems.
}
\note{
The 'exact' values for the inverse Gaussian distribution are not really exact, but evaluated using inverse normal distributions,
for which very good numerical approximation are available in R.
For special cases of \eqn{p} (i.e., \eqn{p = 0, 1, 2, 3}), where no inversion is needed, \code{regions} and \code{method} are set to \code{NA} for all values of \code{y}.
For special cases of \code{y} for other values of \eqn{p} (i.e., \eqn{P(Y = 0)}), \code{regions} and \code{method} are set to \code{NA}.

The three methods are described in Dunn & Smyth (2008).
}
\examples{
# Plot a Tweedie density
y <- seq(0.02, 4, length = 50)
fy <- dtweedie_inversion(y, mu = 1, phi = 1, power = 1.1)
plot(y, fy, type = "l", lwd = 2, ylab = "Density")

}
\references{
Dunn, P. K. and Smyth, G. K. (2008).
Evaluation of Tweedie exponential dispersion model densities by Fourier inversion.
\emph{Statistics and Computing}, 
\bold{18}, 73--86.
\doi{10.1007/s11222-007-9039-6}

Dunn, P. K. and Smyth, G. K. (2008).
Evaluation of Tweedie exponential dispersion model densities by Fourier inversion.
\emph{Statistics and Computing}, 
\bold{18}, 73--86.
\doi{10.1007/s11222-007-9039-6}
}
\keyword{distribution}
