% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_risk_diff.R
\name{print.riskdiff_result}
\alias{print.riskdiff_result}
\title{Print method for riskdiff_result objects}
\usage{
\method{print}{riskdiff_result}(x, show_boundary = TRUE, show_quality = TRUE, ...)
}
\arguments{
\item{x}{A riskdiff_result object from calc_risk_diff()}

\item{show_boundary}{Logical indicating whether to show boundary case details (default: TRUE)}

\item{show_quality}{Logical indicating whether to show quality indicators (default: TRUE)}

\item{...}{Additional arguments passed to print methods}
}
\value{
Invisibly returns the original riskdiff_result object (x). Called primarily
for its side effect of printing formatted results to the console.
}
\description{
Prints risk difference results in a formatted, readable way showing
key statistics including risk differences, confidence intervals, model
types used, and enhanced boundary case diagnostics for v0.2.1+.
}
\examples{
data(cachar_sample)
result <- calc_risk_diff(cachar_sample, "abnormal_screen", "areca_nut")
print(result)

# Suppress boundary details for cleaner output
print(result, show_boundary = FALSE)

}
