% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minmax_img.R
\docType{methods}
\name{minmax_img-methods}
\alias{minmax_img-methods}
\alias{minmax_img}
\alias{minmax_img,nifti-method}
\alias{minmax_img,array-method}
\alias{minmax_img,ANY-method}
\alias{minmax_img,character-method}
\alias{minmax_img,factor-method}
\alias{minmax_img,list-method}
\title{Normalize Image using Range}
\usage{
minmax_img(img)

\S4method{minmax_img}{nifti}(img)

\S4method{minmax_img}{array}(img)

\S4method{minmax_img}{ANY}(img)

\S4method{minmax_img}{character}(img)

\S4method{minmax_img}{factor}(img)

\S4method{minmax_img}{list}(img)
}
\arguments{
\item{img}{character path of image or 
an object of class \code{nifti}, or list of images}
}
\value{
A \code{nifti} object (or list of them) or class of 
object passed in if not specified
}
\description{
Calculates the range of values in an image, then
scales the image minimum to 0 and maximum to 1
}
\examples{
set.seed(5)
dims = rep(10, 4)
arr = array(rpois(prod(dims), lambda = 2), dim = dims)
nim = oro.nifti::nifti(arr)
mimg = minmax_img(nim)
marr = minmax_img(arr)
testthat::expect_equal(array(mimg, dim = dim(mimg)), marr)

set.seed(5)
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
arr[,,10] = 0
nim = oro.nifti::nifti(arr)
rnifti = RNifti::asNifti(nim)
timg = tempimg(nim)
limg = list(factor(timg), factor(timg))
func = minmax_img
func(arr)
func(nim)
func(rnifti)
func(timg)
func(limg)
}
