% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geohash.R
\name{geohash_fwd}
\alias{geohash_fwd}
\alias{geohash_rev}
\alias{geohash_resolution}
\alias{geohash_length}
\title{Convert coordinates to/from Geohash}
\usage{
geohash_fwd(x, len = 12L)

geohash_rev(geohash)

geohash_resolution(len)

geohash_length(resolution = NULL, lat_resolution = NULL, lon_resolution = NULL)
}
\arguments{
\item{x}{A two-column matrix or data frame of coordinates (longitude, latitude)
in decimal degrees, or a list with longitude and latitude components.
Can also be a length-2 numeric vector for a single point.}

\item{len}{Integer specifying the length of the Geohash string (1-18).
Default is 12, which gives approximately 19mm precision. Can be a vector
to specify different lengths for each point.}

\item{geohash}{Character vector of Geohash strings to convert back to coordinates.}

\item{resolution}{Numeric. Desired resolution in degrees for \code{geohash_length()}.}

\item{lat_resolution}{Numeric. Desired latitude resolution in degrees.}

\item{lon_resolution}{Numeric. Desired longitude resolution in degrees.}
}
\value{
\itemize{
\item \code{geohash_fwd()}: Character vector of Geohash strings.
\item \code{geohash_rev()}: Data frame with columns:
\itemize{
\item \code{lon}: Longitude in decimal degrees (center of cell)
\item \code{lat}: Latitude in decimal degrees (center of cell)
\item \code{len}: Length of the Geohash string
\item \code{lat_resolution}: Latitude resolution in degrees (half-height of cell)
\item \code{lon_resolution}: Longitude resolution in degrees (half-width of cell)
}
\item \code{geohash_resolution()}: Data frame with columns:
\itemize{
\item \code{len}: Geohash length
\item \code{lat_resolution}: Latitude resolution in degrees
\item \code{lon_resolution}: Longitude resolution in degrees
}
\item \code{geohash_length()}: Integer, minimum Geohash length to achieve the
specified resolution.
}
}
\description{
Convert geographic coordinates (longitude/latitude) to Geohash strings,
or convert Geohash strings back to coordinates.
}
\details{
Geohash is a geocoding system that encodes geographic coordinates into a
short string of letters and digits. It has a useful property: truncating
a Geohash reduces precision but the truncated code still refers to a
location containing the original point.

The Geohash length determines precision:
\itemize{
\item Length 1: ~5000 km
\item Length 4: ~20 km
\item Length 6: ~610 m
\item Length 8: ~19 m
\item Length 10: ~0.6 m
\item Length 12: ~19 mm (default)
\item Length 18: ~0.0001 mm (maximum)
}

Both \code{geohash_fwd()} and \code{geohash_rev()} are fully vectorized.
}
\examples{
# Single point conversion
(gh <- geohash_fwd(c(147.325, -42.881)))
geohash_rev(gh)

# Multiple points with varying precision
pts <- cbind(
  lon = c(147, -74, 0),
  lat = c(-42, 40.7, 51.5)
)
geohash_fwd(pts, len = c(6, 8, 12))

# Truncation preserves containment
gh <- geohash_fwd(c(147.325, -42.881), len = 12)
substr(gh, 1, 6)  # Lower precision, but still contains original point

# Resolution for different lengths
geohash_resolution(1:12)

# Find length needed for ~1km precision
geohash_length(1/111)  # ~1 degree / 111 km
}
\seealso{
\code{\link[=mgrs_fwd]{mgrs_fwd()}} for Military Grid Reference System encoding,
which provides a different grid-based coordinate system.
}
