% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertex_roles.R
\name{Vertex Roles}
\alias{Vertex Roles}
\alias{gateway_coeff}
\alias{part_coeff}
\alias{within_module_deg_z_score}
\title{Gateway coefficient, participation coefficient, and within-mod degree z-score}
\usage{
gateway_coeff(g, memb, centr = c("btwn.cent", "degree", "strength"),
  A = NULL, weighted = FALSE)

part_coeff(g, memb, A = NULL, weighted = FALSE)

within_module_deg_z_score(g, memb, A = NULL, weighted = FALSE)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{memb}{A numeric vector of membership indices of each vertex}

\item{centr}{Character string; the type of centrality to use in calculating
GC. Default: \code{btwn.cent}}

\item{A}{Numeric matrix; the adjacency matrix of the input graph. Default:
\code{NULL}}

\item{weighted}{Logical indicating whether to calculate metrics using edge
weights. Default: \code{FALSE}}
}
\value{
A vector of the participation coefficients, within-module degree
  z-scores, or gateway coefficients for each vertex of the graph.
}
\description{
\code{gateway_coeff} calculates the gateway coefficient of each vertex,
based on community membership.

\code{part_coeff} calculates the participation coefficient of each vertex,
based on community membership.

\code{within_module_deg_z_score} is a measure of the connectivity from a
given vertex to other vertices in its module/community.
}
\details{
The gateway coefficient \eqn{G_i} of vertex \emph{i} is:
\deqn{G_i = 1 - \sum_{S=1}^{N_M} \left ( \frac{\kappa_{iS}}{\kappa_i} \right
)^2 (g_{iS})^2}
where \eqn{\kappa_{iS}} is the number of edges from vertex \emph{i} to
vertices in module \emph{S}, and \eqn{\kappa_i} is the degree of vertex
\emph{i}. \eqn{N_M} equals the number of modules. \eqn{g_{ii}} is a weight,
defined as:
\deqn{g_{iS} = 1 - \bar{\kappa_{iS}} \bar{c_{iS}}}
where
\deqn{\bar{\kappa_{iS}} = \frac{\kappa_{iS}}{\sum_j \kappa_{jS}}}
for all nodes \eqn{j} in node \eqn{i}'s module, and
\deqn{\bar{c_{iS}} = c_{iS} / max(c_n)}

The participation coefficient \eqn{P_i} of vertex \emph{i} is:
\deqn{P_i = 1 - \sum_{s=1}^{N_M} \left ( \frac{\kappa_{is}}{\kappa_i} \right )^2}
where \eqn{\kappa_{is}} is the number of edges from vertex \emph{i} to
vertices in module \emph{s}, and \eqn{\kappa_s} is the degree of vertex
\emph{i}. \eqn{N_M} equals the number of modules.

As discussed in Guimera et al., \eqn{P_i = 0} if vertex \emph{i} is connected
only to vertices in the same module, and \eqn{P_i = 1} if vertex \emph{i} is
equally connected to all other modules.

The within-module degree z-score is:
\deqn{z_i = \frac{\kappa_i - \bar{\kappa}_{s_i}}{\sigma_{\kappa_{s_i}}}}
where \eqn{\kappa_i} is the number of edges from vertex \emph{i} to vertices
in the same module \eqn{s_i}, \eqn{\bar{\kappa}_{s_i}} is the average of
\eqn{\kappa} over all vertices in \eqn{s_i}, and \eqn{\sigma_{\kappa_{s_i}}}
is the standard deviation.
}
\references{
Vargas, E.R. and Wahl, L.M. (2014) The gateway coefficient: a
  novel metric for identifying critical connections in modular networks.
  \emph{Eur Phys J B}, \bold{87}, 161--170.
  \doi{10.1140/epjb/e2014-40800-7}

Guimera, R. and Amaral, L.A.N. (2005) Cartography of complex
  networks: modules and universal roles. \emph{Journal of Statistical
  Mechanics: Theory and Experiment}, \bold{02}, P02001.
  \doi{10.1088/1742-5468/2005/02/P02001}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
