% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_Slick.R
\docType{class}
\name{Slick-class}
\alias{Slick-class}
\alias{Slick}
\alias{Title}
\alias{Title<-}
\alias{Subtitle}
\alias{Subtitle<-}
\alias{Date}
\alias{Date<-}
\alias{Author}
\alias{Author<-}
\alias{Email}
\alias{Email<-}
\alias{Institution}
\alias{Institution<-}
\alias{Introduction}
\alias{Introduction<-}
\title{Create a \code{Slick} class object}
\usage{
Slick(
  Title = "",
  Subtitle = "",
  Date = Sys.Date(),
  Author = "",
  Email = "",
  Institution = "",
  Introduction = "",
  MPs = NULL,
  OMs = NULL,
  Boxplot = NULL,
  Kobe = NULL,
  Quilt = NULL,
  Spider = NULL,
  Timeseries = NULL,
  Tradeoff = NULL
)

Title(object, lang = "en", markdown = FALSE)

Title(object) <- value

Subtitle(object, lang = "en", markdown = FALSE)

Subtitle(object) <- value

Date(object)

Date(object) <- value

Author(object, markdown = FALSE)

Author(object) <- value

Email(object, markdown = FALSE)

Email(object) <- value

Institution(object, lang = "en", markdown = FALSE)

Institution(object) <- value

Introduction(object, lang = "en", markdown = FALSE)

Introduction(object) <- value
}
\arguments{
\item{Title}{Title for the \code{Slick} object. A character string. For multiple languages,
use a named list with names: \code{en}, \code{es}, \code{fr}, or \code{pt} for the supported languages.}

\item{Subtitle}{Subtitle for the \code{Slick} object. A character string or a named list with
languages: \code{en}, \code{es}, \code{fr}, \code{pt}}

\item{Date}{Date the Slick object was created. Text in format 'YYYY-MM-DD' or class \code{Date} e.g., \code{Sys.Date()}}

\item{Author}{A character vector with Author(s) names. The length of the vector should equal the number of authors.}

\item{Email}{A character vector with email addresses for the author(s). Must be same length as \code{Author}. Can include Markdown.}

\item{Institution}{A character vector with institution details for the author(s). Must be same length as \code{Author}. Can include Markdown.}

\item{Introduction}{Introduction text for the \code{Slick} object. Supports all markdown formatting. Character string, must be length 1.
For multiple languages, use a named list with names: \code{en}, \code{es}, \code{fr}, \code{pt} for the supported languages.}

\item{MPs}{An object of class \code{\link[=MPs-class]{MPs-class()}}}

\item{OMs}{An object of class \code{\link[=OMs-class]{OMs-class()}}}

\item{Boxplot}{An object of class \code{\link[=Boxplot-class]{Boxplot-class()}}}

\item{Kobe}{An object of class \code{\link[=Kobe-class]{Kobe-class()}}}

\item{Quilt}{An object of class \code{\link[=Quilt-class]{Quilt-class()}}}

\item{Spider}{An object of class \code{\link[=Spider-class]{Spider-class()}}}

\item{Timeseries}{An object of class \code{\link[=Timeseries-class]{Timeseries-class()}}}

\item{Tradeoff}{An object of class \code{\link[=Tradeoff-class]{Tradeoff-class()}}}

\item{object}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{lang}{Optional text string specifying the language (if available).
Either 'en', 'es', 'fr', or 'pt' for English, Spanish, French, or Portuguese respectively}

\item{markdown}{Logical. Process markdown?}

\item{value}{The value to assign to the object. See \code{Slots} for format of the
relevant object class}
}
\value{
A \code{Slick} object
}
\description{
The \code{Slick} class is the main object class used in the \code{Slick} package. It
contains sub-objects for the management procedures \code{\link[=MPs]{MPs()}}, operating models \code{\link[=OMs]{OMs()}},
and the six chart types: \code{\link[=Boxplot]{Boxplot()}}, \code{\link[=Kobe]{Kobe()}}, \code{\link[=Quilt]{Quilt()}}, \code{\link[=Spider]{Spider()}},
\code{\link[=Timeseries]{Timeseries()}}, and \code{\link[=Tradeoff]{Tradeoff()}}, as well as metadata information for the \code{Slick}
object such as \code{Title}, \code{Author}, and \code{Introduction}.
}
\details{
Objects of class \code{Slick} are created with \code{Slick()}.

Like all S4 objects in \code{Slick}, slots in this object can be accessed and
assigned using functions corresponding to slot name. See \code{Usage} and \code{Functions} section.
\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
\item \code{pt}: Portuguese
}

All functions with the exception of \code{Date} support Markdown.
}
}
\section{Functions}{
\itemize{
\item \code{Slick()}: Create a \code{\link[=Slick-class]{Slick-class()}} object

\item \code{Title()}: Access \code{Title}, Multi-language support

\item \code{Title(object) <- value}: Assign \code{Title}, Multi-language support

\item \code{Subtitle()}: Access \code{Subtitle}, Multi-language support

\item \code{Subtitle(object) <- value}: Assign \code{Subtitle}, Multi-language support

\item \code{Date()}: Access \code{Date}

\item \code{Date(object) <- value}: Assign \code{Date}

\item \code{Author()}: Access \code{Author}

\item \code{Author(object) <- value}: Assign \code{Author}

\item \code{Email()}: Access \code{Email}

\item \code{Email(object) <- value}: Assign \code{Email}

\item \code{Institution()}: Access \code{Institution}

\item \code{Institution(object) <- value}: Assign \code{Institution}

\item \code{Introduction()}: Access \code{Introduction}

\item \code{Introduction(object) <- value}: Assign \code{Introduction}, can include Markdown. See \code{Examples}

}}
\section{Slots}{

\describe{
\item{\code{Title}}{Title for the \code{Slick} object. A character string. For multiple languages,
use a named list with names: \code{en}, \code{es}, \code{fr}, or \code{pt} for the supported languages.}

\item{\code{Subtitle}}{Subtitle for the \code{Slick} object. A character string or a named list with
languages: \code{en}, \code{es}, \code{fr}, \code{pt}}

\item{\code{Date}}{Date the Slick object was created. Text in format 'YYYY-MM-DD' or class \code{Date} e.g., \code{Sys.Date()}}

\item{\code{Author}}{A character vector with Author(s) names. The length of the vector should equal the number of authors.}

\item{\code{Email}}{A character vector with email addresses for the author(s). Must be same length as \code{Author}. Can include Markdown.}

\item{\code{Institution}}{A character vector with institution details for the author(s). Must be same length as \code{Author}. Can include Markdown.}

\item{\code{Introduction}}{Introduction text for the \code{Slick} object. Supports all markdown formatting. Character string, must be length 1.
For multiple languages, use a named list with names: \code{en}, \code{es}, \code{fr}, \code{pt} for the supported languages.}

\item{\code{MPs}}{An object of class \code{\link[=MPs-class]{MPs-class()}}}

\item{\code{OMs}}{An object of class \code{\link[=OMs-class]{OMs-class()}}}

\item{\code{Boxplot}}{An object of class \code{\link[=Boxplot-class]{Boxplot-class()}}}

\item{\code{Kobe}}{An object of class \code{\link[=Kobe-class]{Kobe-class()}}}

\item{\code{Quilt}}{An object of class \code{\link[=Quilt-class]{Quilt-class()}}}

\item{\code{Spider}}{An object of class \code{\link[=Spider-class]{Spider-class()}}}

\item{\code{Timeseries}}{An object of class \code{\link[=Timeseries-class]{Timeseries-class()}}}

\item{\code{Tradeoff}}{An object of class \code{\link[=Tradeoff-class]{Tradeoff-class()}}}
}}

\examples{

# Assign values to a new `Slick` object
slick <- Slick()

Title(slick) <- 'An Example Slick Object'
Subtitle(slick) <- ""
Date(slick) <- Sys.Date()
Author(slick) <- 'Adrian Hordyk'
Email(slick) <-  "[mailto:adrian@bluematterscience.com](mailto:adrian@bluematterscience.com)"
Institution(slick) <- "[Blue Matter Science](bluematterscience.com)"

Introduction(slick) <- "This is the Introduction text"

# Access values from `Slick` object
Title(slick)
Subtitle(slick)
Date(slick)
Author(slick)
Email(slick)
Institution(slick)
Introduction(slick)

}
\seealso{
\code{\link[=MPs]{MPs()}}, \code{\link[=OMs]{OMs()}}, \code{\link[=Boxplot]{Boxplot()}}, \code{\link[=Kobe]{Kobe()}}, \code{\link[=Quilt]{Quilt()}},
\code{\link[=Spider]{Spider()}}, \code{\link[=Timeseries]{Timeseries()}}, \code{\link[=Tradeoff]{Tradeoff()}}, \code{\link[=Check]{Check()}},
\code{\link[=Title]{Title()}}, \code{\link[=Subtitle]{Subtitle()}}, \code{\link[=Date]{Date()}}, \code{\link[=Author]{Author()}}, \code{\link[=Email]{Email()}},
\code{\link[=Institution]{Institution()}}, \code{\link[=Introduction]{Introduction()}}
}
