% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sca_mcmc1.R
\name{sca_mcmc1}
\alias{sca_mcmc1}
\title{Alternative Sca-MCMC Implementation for Variable Selection}
\usage{
sca_mcmc1(
  y,
  X,
  family = c("poisson", "pareto", "gamma"),
  method = c("ScaI", "ScaII", "ScaIII"),
  N_chain = 8,
  n_iter = 5000,
  beta_star = NULL,
  alpha_gamma = 2
)
}
\arguments{
\item{y}{Numeric response vector.}

\item{X}{Design matrix (n x p).}

\item{family}{Character, one of "poisson", "pareto", "gamma".}

\item{method}{Mutation strategy: "ScaI", "ScaII", or "ScaIII".}

\item{N_chain}{Number of parallel tempered chains (>1).}

\item{n_iter}{Total MCMC iterations.}

\item{beta_star}{Target (true) inclusion vector (for adaptive Q0; optional).}

\item{alpha_gamma}{Shape parameter if family = "gamma" (default 2).}
}
\value{
List containing:
\item{beta_chain}{Array [n_iter x p x N_chain] of sampled inclusion vectors.}
\item{family}{Model family used.}
\item{method}{Mutation strategy used.}
}
\description{
An alternative implementation of Sca-MCMC for variable selection
with binary inclusion indicators.
}
