% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_order_vectors}
\alias{mvl_order_vectors}
\title{Return permutation sorting vector entries}
\usage{
mvl_order_vectors(
  L,
  indices = NULL,
  decreasing = FALSE,
  sort_function = ifelse(decreasing, 2, 1)
)
}
\arguments{
\item{L}{list of vector like MVL_OBJECTs}

\item{indices}{list of indices into objects to sort. If absent or NULL it is assumed to be from 1 to length of the object.}

\item{decreasing}{whether to sort in ascending or decreasing order. This parameter is provided for compatibility with \code{order()} function}

\item{sort_function}{specifies desired sort order}
}
\value{
sorted indices
}
\description{
This function is similar to R  order() function, but operates on MVL_OBJECTS.
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, runif(100), "vec1")
Mtmp<-mvl_remap(Mtmp)
permutation1<-mvl_order_vectors(list(Mtmp["vec1", ref=TRUE]))
}
}
\seealso{
\code{\link{mvl_hash_vectors}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_group}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_indexed_copy}}, \code{\link{mvl_merge}}
}
