\name{compute_rvs}
\alias{compute_rvs}
\title{Compute Radicle Vigor Score (RVS)}
\description{
Calculates a continuous radicle vigor score on a \code{[0, 1]} scale
from radicle emergence counts and total seed counts. Unlike the discrete
Radicle Vigor Factor (RVF) in \code{PSRICalc}, RVS varies continuously.
}
\usage{
compute_rvs(radicle_count, total_seeds)
}
\arguments{
  \item{radicle_count}{Integer. Number of seeds with visible radicle
    emergence. If \code{NULL} or \code{NA}, returns 0.}
  \item{total_seeds}{Integer. Total number of seeds in the replicate.}
}
\value{
Numeric value in \code{[0, 1]}.
}
\examples{
compute_rvs(18, total_seeds = 25)
compute_rvs(0, total_seeds = 25)
compute_rvs(NULL, total_seeds = 25)
}
\seealso{\code{\link{compute_psri_sm}}}
