% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obwoe.R
\name{control.obwoe}
\alias{control.obwoe}
\title{Control Parameters for Optimal Binning Algorithms}
\usage{
control.obwoe(
  bin_cutoff = 0.05,
  max_n_prebins = 20,
  convergence_threshold = 1e-06,
  max_iterations = 1000,
  bin_separator = "\%;\%",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{bin_cutoff}{Numeric value in \eqn{(0, 1)} specifying the minimum
proportion of total observations that a bin must contain. Bins with
fewer observations are merged with adjacent bins. Serves as a regularization
mechanism to prevent overfitting and ensure statistical stability of
WoE estimates. Recommended range: 0.02 to 0.10. Default is 0.05 (5\%).}

\item{max_n_prebins}{Integer specifying the maximum number of initial bins
created before optimization. For high-cardinality categorical features,
categories with similar event rates are pre-merged until this limit is
reached. Higher values preserve more granularity but increase computational
cost. Typical range: 10 to 50. Default is 20.}

\item{convergence_threshold}{Numeric value specifying the tolerance for
algorithm convergence. Iteration stops when the absolute change in
Information Value between successive iterations falls below this threshold:
\eqn{|IV_{t} - IV_{t-1}| < \epsilon}. Smaller values yield more precise
solutions at higher computational cost. Typical range: \eqn{10^{-4}} to
\eqn{10^{-8}}. Default is \eqn{10^{-6}}.}

\item{max_iterations}{Integer specifying the maximum number of optimization
iterations. Prevents infinite loops in degenerate cases. If the algorithm
does not converge within this limit, it returns the best solution found.
Typical range: 100 to 10000. Default is 1000.}

\item{bin_separator}{Character string used to concatenate category names
when multiple categories are merged into a single bin. Should be a string
unlikely to appear in actual category names. Default is \code{"\%;\%"}.}

\item{verbose}{Logical indicating whether to print progress messages during
feature processing. Useful for debugging or monitoring long-running jobs.
Default is \code{FALSE}.}

\item{...}{Additional named parameters reserved for algorithm-specific
extensions. Currently unused but included for forward compatibility.}
}
\value{
An S3 object of class \code{"obwoe_control"} containing all specified
  parameters. This object is validated and can be passed directly to
  \code{\link{obwoe}}.
}
\description{
Constructs a validated list of control parameters for the \code{\link{obwoe}}
master interface. These parameters govern the behavior of all supported
binning algorithms, including convergence criteria, minimum bin sizes,
and optimization limits.
}
\details{
\subsection{Parameter Impact on Results}{

\strong{bin_cutoff}: Lower values allow smaller bins, which may capture
subtle patterns but risk unstable WoE estimates. The variance of WoE
estimates increases as \eqn{1/n_i} where \eqn{n_i} is the bin size.
For bins with fewer than ~30 observations, consider using Laplace or
Bayesian smoothing (applied automatically by most algorithms).

\strong{max_n_prebins}: Critical for categorical features with many levels.
If a feature has 100 categories, setting \code{max_n_prebins = 20} will
pre-merge similar categories into 20 groups before optimization.

\strong{convergence_threshold}: Trade-off between precision and speed.
For exploratory analysis, \eqn{10^{-4}} is sufficient. For production
models requiring reproducibility, use \eqn{10^{-8}} or smaller.
}
}
\examples{
# Default control parameters
ctrl_default <- control.obwoe()
print(ctrl_default)

# Conservative settings for production
ctrl_production <- control.obwoe(
  bin_cutoff = 0.03,
  max_n_prebins = 30,
  convergence_threshold = 1e-8,
  max_iterations = 5000
)

# Aggressive settings for exploration
ctrl_explore <- control.obwoe(
  bin_cutoff = 0.01,
  max_n_prebins = 50,
  convergence_threshold = 1e-4,
  max_iterations = 500
)

}
\seealso{
\code{\link{obwoe}} for the main binning interface.
}
