\name{waiting}
\alias{waiting}
\title{Waiting Times of 100 Bank Customers}

\description{
This dataset contains the waiting times (in minutes) of 100 bank customers, as
originally analyzed in Ghitany, Atieh, and Nadarajah (2008) in their study on the
Lindley distribution.
}

\usage{
waiting
}

\format{
A numeric vector of length 100 containing waiting times in minutes.
}

\value{
An object of class \code{"numeric"}.

The vector consists of 100 observed waiting times (in minutes), each
corresponding to a single bank customer. Each value represents the amount of
time a customer waited before receiving service. The dataset is commonly used
in reliability analysis and applied probability to illustrate lifetime and
waiting-time distributions, particularly the Lindley distribution.
}

\details{
These data were used to illustrate applications of the Lindley distribution in
modeling waiting times. The dataset has been cited widely in reliability and
lifetime distribution literature.
}

\references{
Ghitany, M. E., Atieh, B., & Nadarajah, S. (2008). Lindley distribution and its
application. \emph{Mathematics and Computers in Simulation}, 78, 493--506.
}

\examples{
summary(waiting)

hist(
  waiting,
  main = "Histogram of Waiting Times",
  xlab = "Minutes"
)
}

\keyword{datasets}

