% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_docs_polish_households.R
\docType{data}
\name{polish_households}
\alias{polish_households}
\title{Polish Household Budget Data with Simulated Nonignorable Nonresponse}
\format{
A data frame with 19,330 rows and 17 columns. The key variables are:
\describe{
  \item{class}{TODO}
  \item{voi}{TODO}
  \item{bio}{TODO}
  \item{type}{TODO}
  \item{d345}{TODO}
  \item{d347}{TODO}
  \item{d348}{TODO}
  \item{d36}{TODO}
  \item{d38}{TODO}
  \item{d61}{TODO}
  \item{noper}{TODO}
  \item{income}{TODO}
  \item{expenditure}{TODO}
  \item{y_exp}{Numeric. The **true** scaled expenditure
               (`expenditure / mean(expenditure)`). This is the complete
               study variable without missingness.}
  \item{resp}{TODO}
  \item{R}{Integer. The simulated response indicator (1=responded, 0=nonresponse).}
  \item{y_exp_miss}{Numeric. The **observed** scaled expenditure, containing
                   7,778 `NA` values where `R = 0`. This is the variable
                   to be used as the NMAR-affected outcome.}
}
}
\source{
TODO
}
\usage{
polish_households
}
\description{
This dataset is derived from the `h05` dataset (Polish household budgets for 2005)
found in the `RClas` package. The original data was cleaned to remove
all rows with missing values.
}
\details{
To create a realistic test case for nonignorable nonresponse (NMAR),
a nonresponse mechanism was simulated and applied to the scaled
expenditure variable (`y_exp`).

The key simulation steps were:
1.  `y_exp` (true study variable) was created by scaling total expenditure.
2.  A true response probability (`resp`) was created using the logistic
    model: `plogis(1 - 0.6 * y_exp)`.
3.  A response indicator (`R`) was simulated based on this probability.
4.  The final variable `y_exp_miss` was generated by setting `y_exp` to `NA`
    wherever `R` was 0.

The response is **nonignorable** because the probability of missingness
depends directly on the value of the expenditure variable itself.
}
\seealso{
`riddles_case1`, `riddles_case2`, `riddles_case3`, `riddles_case4`
}
\keyword{dataset}
