% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KbSkewness.R
\name{PearsonSkew}
\alias{PearsonSkew}
\title{Pearson's coefficient of skewness}
\usage{
PearsonSkew(x)
}
\arguments{
\item{x}{a vector of original observations.}
}
\value{
\code{PearsonSkew} gives the sample Pearson's univariate skewness.
}
\description{
Compute Pearson's coefficient of skewness.
}
\details{
Pearson's coefficient of skewness is defined as
\deqn{\gamma_1 = \frac{E[(X - \mu)^3]}{(\sigma^3)}}
where \eqn{\mu = E(X)} and \eqn{\sigma^2 = E[(X - \mu)^2]}. The sample version based on a random sample \eqn{x_1,x_2,\ldots,x_n} is defined as
\deqn{\hat{\gamma_1} = \frac{\sum_{i=1}^n (x_i - \bar{x})^3}{n s^3}}
where \eqn{\bar{x}} is the sample mean and \eqn{s} is the sample standard deviation of the data, respectively.
}
\examples{
# Compute Pearson's univariate skewness

set.seed(2019)
x <- rnorm(1000) # Normal Distribution
PearsonSkew(x)

set.seed(2019)
y <- rlnorm(1000, meanlog = 1, sdlog = 0.25) # Log-normal Distribution
PearsonSkew(y)

}
\references{
Pearson, K. (1894). Contributions to the mathematical theory of evolution. \emph{Philos. Trans. R. Soc. Lond.} A 185, 71-110.

Pearson, K. (1895). Contributions to the mathematical theory of evolution II: skew variation in homogeneous material. \emph{Philos. Trans. R. Soc. Lond.} A 86, 343-414.
}
