% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicates.R
\name{plot_peptide_mass_measurement}
\alias{plot_peptide_mass_measurement}
\title{Plot peptide mass measurement}
\usage{
plot_peptide_mass_measurement(
  dat,
  protein = dat[["Protein"]][1],
  state = dat[["State"]][1],
  sequence = dat[["Sequence"]][1],
  show_charge_values = TRUE,
  time_t = unique(dat[["Exposure"]])[3],
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{dat}{data produced by 
\code{\link{read_hdx}} function}

\item{protein}{chosen protein}

\item{state}{biological state for chosen protein}

\item{sequence}{sequence of chosen peptide}

\item{show_charge_values}{\code{logical}, indicator if the data
is shown for replicates or for charge values within the 
replicates}

\item{time_t}{chosen time point}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app)}
}
\value{
a [ggplot2::ggplot()] object.
}
\description{
Plot the mass measurements
from replicates for peptide in specific time point.
}
\details{
This function shows the measurements of mass from
different replicates for specific peptide in specific state
in specific time point of measurement on the plot. 
Moreover, on the plot is shown the average mass from the 
replicates, used later in calculations. The ribbon next to the
dotted average mass indicates the uncertainty.
}
\examples{
plot_peptide_mass_measurement(alpha_dat, sequence = "FGSDDEEESEEAKRLRE")
plot_peptide_mass_measurement(alpha_dat, sequence = "FGSDDEEESEEAKRLRE", show_charge_values = FALSE)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_exp_masses_per_replicate}}
\code{\link{calculate_exp_masses}}
\code{\link{calculate_state_uptake}}
\code{\link{calculate_diff_uptake}}
}
