% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_masses.R
\name{calculate_exp_masses}
\alias{calculate_exp_masses}
\title{Calculate measured mass, aggregated from the replicates of the
experiment}
\usage{
calculate_exp_masses(dat)
}
\arguments{
\item{dat}{data as imported by the \code{\link{read_hdx}} function}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Calculate the measured mass (with the uncertainty of the measurement)
as aggregated data from the replicates of the experiment.
}
\details{
Each measurement is repeated at least three times to obtain reliable
result and to calculate uncertainty of the measurement. For more information 
on how the data is aggregated or how the uncertainty is calculated, see the 
documentation.
}
\examples{
calculate_exp_masses(alpha_dat)

}
\seealso{
\code{\link{read_hdx}} 
\code{\link{calculate_exp_masses_per_replicate}}
\code{\link{calculate_state_uptake}}
}
