% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HNPclassifier.r
\name{hnp_umbrella_flex}
\alias{hnp_umbrella_flex}
\title{HNP Umbrella (flex): use custom score functions and pre-split data}
\usage{
hnp_umbrella_flex(
  score_data,
  threshold_data,
  error_data,
  levels,
  tolerances,
  A1 = NULL,
  score_functions = NULL,
  class_col
)
}
\arguments{
\item{score_data}{A data.frame for fitting/deriving scoring behavior.}

\item{threshold_data}{A data.frame used to compute thresholds.}

\item{error_data}{A data.frame used to estimate empirical errors.}

\item{levels}{Numeric vector of length 2. Confidence levels (alpha) for
class 1 and class 2 under-classification controls.}

\item{tolerances}{Numeric vector of length 2. Tolerance (delta) values for
the corresponding classes.}

\item{A1}{Optional numeric vector of candidate thresholds for class 1.}

\item{score_functions}{A list with at least two functions: \code{T1}, \code{T2}.
Each must accept a data.frame and return numeric scores.}

\item{class_col}{Character scalar. Name of the class column in the data.}
}
\value{
A classifier function \code{function(new_data) data.frame(result=...)},
or \code{NULL} if no valid classifier is found.
}
\description{
Flexible variant of the HNP Umbrella algorithm that accepts
user-provided scoring functions and explicit data splits for thresholding
and error estimation. This bypasses model training inside and focuses on
threshold selection with confidence controls.
}
\examples{
set.seed(123)
n <- 500
score_data <- data.frame(x=rnorm(n), y=factor(sample(1:3, n, replace=TRUE)))
threshold_data <- data.frame(x=rnorm(n), y=factor(sample(1:3, n, replace=TRUE)))
error_data <- data.frame(x=rnorm(n), y=factor(sample(1:3, n, replace=TRUE)))
T1 <- function(d) as.numeric(d$x > 0)
T2 <- function(d) as.numeric(d$x > 0.5)
clf <- hnp_umbrella_flex(score_data, threshold_data, error_data,
                         levels = c(0.05, 0.05), tolerances = c(0.01, 0.01),
                         score_functions = list(T1, T2), class_col = 'y')
preds <- clf(score_data)
}
\references{
Lijia Wang, Y. X. Rachel Wang, Jingyi Jessica Li, and Xin Tong (2024).
"Hierarchical Neyman-Pearson Classification for Prioritizing Severe Disease
Categories in COVID-19 Patient Data."
\emph{Journal of the American Statistical Association}, 119(545), 39-51.
\doi{10.1080/01621459.2023.2270657}
}
