% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gurobi_numerical_optimization_search.R
\name{initGurobiNumericalOptimizationExperimentalDesignObject}
\alias{initGurobiNumericalOptimizationExperimentalDesignObject}
\title{Begin Gurobi Optimized Search}
\usage{
initGurobiNumericalOptimizationExperimentalDesignObject(
  X = NULL,
  objective = "mahal_dist",
  Kgram = NULL,
  num_cores = 2,
  w_0 = NULL,
  initial_time_limit_sec = 5 * 60,
  restart_time_limit_sec = 60,
  max_number_of_restarts = 0,
  max_no_good_cuts = 0,
  verbose = TRUE,
  gurobi_params = list(),
  use_safe_inverse = FALSE,
  r,
  pool_solutions = NULL,
  pool_gap = 0.2,
  pool_gap_abs = NULL,
  pool_search_mode = 2,
  mip_gap = 1e-04,
  mip_gap_abs = 1e-10,
  mip_focus = 1,
  heuristics = 0.2,
  cuts = 2,
  presolve = 2
)
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design.}

\item{objective}{The objective function to use when searching design space. This is a string
with valid values "\code{mahal_dist}" (the default) or "\code{kernel}".}

\item{Kgram}{If the \code{objective = kernel}, this argument is required to be an \code{n x n} matrix whose
entries are the evaluation of the kernel function between subject i and subject j. Default is \code{NULL}.}

\item{num_cores}{Number of cores to use during search. Default is \code{2}.}

\item{w_0}{The initial starting location (optional).}

\item{initial_time_limit_sec}{The maximum amount of time the optimizer can run for in seconds. The default is \code{5 * 60}.}

\item{restart_time_limit_sec}{The maximum amount of time each restart can run for in seconds. The default is \code{60}.}

\item{max_number_of_restarts}{The maximum number of restarts to attempt if too few unique solutions are returned.
Default is \code{0}.}

\item{max_no_good_cuts}{The maximum number of no-good cuts to attempt. Default is \code{0} (disabled).}

\item{verbose}{Should Gurobi log to console? Default is \code{TRUE}.}

\item{gurobi_params}{A list of optional parameters to be passed to Gurobi (see their documentation online).}

\item{use_safe_inverse}{Should a regularized inverse be used for the Mahalanobis objective?
Default is \code{FALSE}.}

\item{r}{Number of solution vectors to request from the Gurobi pool.}

\item{pool_solutions}{Number of solutions to request from the Gurobi pool. Defaults to \code{10 * r}.}

\item{pool_gap}{Relative optimality gap for the pool. Default is \code{0.2}. Use \code{NULL} to skip.}

\item{pool_gap_abs}{Absolute optimality gap for the pool. Default is \code{NULL} to skip.}

\item{pool_search_mode}{Solution pool search mode. Default is \code{2} for diverse solutions.}

\item{mip_gap}{Relative MIP gap target (stops when \code{|best-bound - best-incumbent| / |best-incumbent| <= mip_gap}).
Lower values force deeper search. Default is \code{1e-4}.}

\item{mip_gap_abs}{Absolute MIP gap target (stops when \code{|best-bound - best-incumbent| <= mip_gap_abs}).
Lower values force deeper search. Default is \code{1e-10}.}

\item{mip_focus}{Search focus: \code{0} (balance), \code{1} (find feasible solutions), \code{2} (prove optimality),
\code{3} (bound improvement). Default is \code{1}.}

\item{heuristics}{Heuristics effort in \code{[0,1]} where higher values spend more time on heuristics.
Default is \code{0.2}.}

\item{cuts}{Cut aggressiveness: \code{-1} (automatic), \code{0} (off), \code{1} (conservative),
\code{2} (aggressive), \code{3} (very aggressive). Default is \code{2}.}

\item{presolve}{Presolve aggressiveness: \code{-1} (automatic), \code{0} (off), \code{1} (conservative),
\code{2} (aggressive). Default is \code{2}.}
}
\value{
A list object which houses the results from Gurobi. Depending on the \code{gurobi_parms},
							the data within will be different. The most relevant tags are \code{x} for the best found solution and \code{objval}
							for the object
}
\description{
This method creates an object of type optimal_experimental_design and will immediately initiate
a search through allocation space for forced balance designs. Make sure you setup Gurobi properly first. This means
applying for a license, downloading, installing, registering it on your computer using the \code{grbgetkey} command
with the license file in the default directory. Then, in R, install the package from the file in your gurobi directory.
}
\details{
Currently, this method does not return multiple vectors. This will be improved in a later 
version. If you want this functionality now, use the hacked-up method \code{gurobi_multiple_designs}.
}
\examples{
\dontrun{
if ("gurobi" \%in\% loadedNamespaces()) {
  set.seed(1)
  X = matrix(rnorm(12), nrow = 6)
  gobj = initGurobiNumericalOptimizationExperimentalDesignObject(
    X,
    r = 2,
    num_cores = 1,
    initial_time_limit_sec = 5,
    verbose = FALSE
  )
  gobj$n
}
}
}
\author{
Adam Kapelner
}
