% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{weight.com}
\alias{weight.com}
\title{Compute model averaging weights}
\usage{
weight.com(
  data = NULL,
  numk = NULL,
  hosking = NULL,
  kpar = NULL,
  numom = 3,
  xqa = NULL,
  varcom = TRUE,
  boot.lme = TRUE,
  cov.lme = NULL,
  surr = FALSE,
  type = "full",
  trim = NULL,
  cov.type = "ratio",
  bma = TRUE,
  pen = "norm"
)
}
\arguments{
\item{data}{Numeric vector of data.}

\item{numk}{Number of candidate submodels.}

\item{hosking}{List containing LME results, MLE, and bootstrap information.}

\item{kpar}{Numeric vector of candidate xi values.}

\item{numom}{Number of L-moments to use (default 3).}

\item{xqa}{Probability vector for surrogate model fitting.}

\item{varcom}{Logical. Whether to compute variance components (default TRUE).}

\item{boot.lme}{Logical. Whether bootstrap LME was performed (default TRUE).}

\item{cov.lme}{Pre-computed LME covariance (default NULL).}

\item{surr}{Logical. Whether to compute surrogate quantiles (default FALSE).}

\item{type}{Type of computation: "full" (default).}

\item{trim}{Left trimming level for L-moments.}

\item{cov.type}{Covariance type: "ratio" or "lambda" (default "ratio").}

\item{bma}{Logical. Whether to compute BMA weights (default TRUE).}

\item{pen}{BMA prior type: "norm" or "beta" (default "norm").}
}
\value{
A list containing:
\describe{
  \item{weight}{Weighting method name}
  \item{numk}{Number of submodels}
  \item{wtgd}{MA weight vector (length numk)}
  \item{bmaw}{BMA weight vector (length numk)}
  \item{zp}{Quantile matrix (numq x numk)}
  \item{kpar}{Candidate xi values}
  \item{prob.call}{Submodel fitting results}
  \item{xzp}{Surrogate quantile matrix (if surr=TRUE)}
}
}
\description{
Internal function that computes weights for model averaging
across K candidate GEV submodels. Supports multiple weighting schemes
including likelihood-based, generalized L-moment distance, and median-based
methods. Optionally includes BMA prior integration.
}
\keyword{internal}
