% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov_functions.R
\name{vcov_local_loading}
\alias{vcov_local_loading}
\title{Get the covariance estimates for the local factor loadings}
\usage{
vcov_local_loading(object, i, j)
}
\arguments{
\item{object}{An S3 object of class 'multi_result' created by multilevel().}

\item{i}{An integer indicating the \eqn{i}-th block.}

\item{j}{An integer indicating the \eqn{j}-th individual in the \eqn{i}-th block.}
}
\value{
An \eqn{r_{i} \times r_{i}} covariance matrix.
}
\description{
This function generates the covariance estimates
for the local loadings for the \eqn{j}-th individual in block \eqn{i}.
}
\examples{
panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
vcov_local_loading_11 <- vcov_local_loading(est_multi, i = 1, j = 1)
}
