% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_MCA.R
\name{trainer_MCA}
\alias{trainer_MCA}
\title{Trainer: Name an MCA dimension (FactoMineR::MCA) with an LLM-ready prompt}
\usage{
trainer_MCA(
  mca_obj,
  dimension = 1L,
  proba = 0.05,
  introduction = NULL,
  audience = c("beginner", "applied", "advanced"),
  summary_only = FALSE,
  llm_model = "llama3",
  generate = FALSE
)
}
\arguments{
\item{mca_obj}{A MCA object returned by \code{FactoMineR::MCA()}.}

\item{dimension}{Integer scalar; the dimension (component) to name (default 1).}

\item{proba}{Numeric in (0,1]; significance threshold used by
\code{FactoMineR::dimdesc()} to characterize the dimension (default 0.05).}

\item{introduction}{Optional character string giving the study context.
Defaults to a generic description.}

\item{audience}{One of \code{c("beginner","applied","advanced")}.}

\item{summary_only}{Logical; if TRUE, return a compact 3-bullet executive
summary (uses \code{trainer_core_summary_only_block()}).}

\item{llm_model}{Character; model name for your generator backend
(default \code{"llama3"}).}

\item{generate}{Logical; if TRUE, calls
\code{trainer_core_generate_or_return()} and returns a list with
\code{prompt}, \code{response}, and \code{model}. If FALSE, returns the
prompt string.}
}
\value{
If \code{generate = FALSE}, a character prompt string.
  If \code{generate = TRUE}, a list with \code{prompt}, \code{response}, and \code{model}.
}
\description{
Builds an English-only, audience-tailored prompt to name and justify a
Multiple Correspondence Analysis (MCA) dimension from a FactoMineR::MCA
object. The function never invents numbers: it passes verbatim excerpts from
\code{summary(mca_obj)} and \code{FactoMineR::dimdesc()} filtered at a given
significance threshold \code{proba}, and instructs how to read and name the axis.
}
\examples{
\dontrun{
# Example: tea (FactoMineR)
if (requireNamespace("FactoMineR", quietly = TRUE)) {
  data(tea, package = "FactoMineR")
  res_mca <- FactoMineR::MCA(tea, quanti.sup = 19, quali.sup = 20:36, graph = FALSE)

  intro <- "A survey on tea consumption practices and contexts was summarized by MCA."
  intro <- gsub("\n", " ", intro); intro <- gsub("\\\\s+", " ", intro)

  # Applied audience
  prompt <- trainer_MCA(res_mca,
                        dimension = 1,
                        proba = 0.01,
                        introduction = intro,
                        audience = "applied",
                        generate = FALSE)
  cat(prompt)

  res <- gemini_generate(prompt, compile_to = "html")
}
}
}
