% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Mixed.R
\name{AvC_MLL}
\alias{AvC_MLL}
\title{Average Catch with a size limit}
\usage{
AvC_MLL(x, Data, reps = 100, plot = FALSE)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the TAC, Retention slot(s) populated
}
\description{
A example mixed control MP that uses the average catch output control MP together with a
minimul size limit set at the size of maturity.
}
\details{
The average catch method is very simple. The mean historical catch is calculated and used to set
a constant catch limit (TAC). If \code{reps} > 1 then the \code{reps} samples are drawn from a log-normal
distribution with mean \code{TAC} and standard deviation (in log-space) of 0.2.

For completeness, the TAC is calculated by:

\deqn{\textrm{TAC} =\frac{\sum_{y=1}^{\textrm{n}}{C_y}}{\textrm{n}}}

where \eqn{\textrm{TAC}} is the the mean catch recommendation, \eqn{n} is the number of historical years, and
\eqn{C_y}  is the catch in historical year \eqn{y}.

The size of retention is set to the length of maturity.

This MP has been included for demonstration purposes of a mixed control MP.
}
\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{AvC_MLL}: Cat, LHYear, Year
}

\section{Rendered Equations}{

See \href{https://dlmtool.openmse.com/reference/AvC_MLL.html}{Online Documentation} for correctly rendered equations
}

\examples{
Rec <- AvC_MLL(1, MSEtool::Cobia, reps=1000, plot=TRUE) # 1,000 log-normal samples with CV = 0.2
}
\seealso{
Other Average Catch MPs: 
\code{\link{AvC}()},
\code{\link{DCACs}()}
}
\concept{Average Catch MPs}
