% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_univiariate.R
\name{cyt_univariate}
\alias{cyt_univariate}
\title{Pairwise Univariate Tests Between Two Groups}
\usage{
cyt_univariate(
  data,
  scale = NULL,
  method = c("auto", "ttest", "wilcox"),
  verbose = TRUE,
  format_output = FALSE,
  custom_fn = NULL,
  p_adjust_method = NULL
)
}
\arguments{
\item{data}{A data frame or matrix containing both categorical
and numeric variables.}

\item{scale}{A character specifying a transformation to apply to
numeric variables prior to testing.  Choices are \code{NULL} (no
transformation), "log2", "log10", "zscore", or
"custom".  When set to "custom", supply a function via
\code{custom_fn}.}

\item{method}{Character specifying the test to perform.  Use
"auto" (default) to select between t‑test and Wilcoxon based
on Shapiro–Wilk normality tests for each outcome; "ttest" to
always use Student’s t‑test; or "wilcox" to always use the
Wilcoxon rank–sum test.}

\item{verbose}{Logical indicating whether to return the results.
Provided for backward compatibility but has no effect on printing.}

\item{format_output}{Logical.  If \code{TRUE}, returns the results as
a tidy data frame; if \code{FALSE} (default), returns a list of
test objects similar to the original function.}

\item{custom_fn}{A function to apply when \code{scale = "custom"}.}

\item{p_adjust_method}{Character or \code{NULL}. Method passed to
\code{p.adjust()} for correcting p-values across all comparisons
(e.g., \code{"BH"} for Benjamini-Hochberg). If \code{NULL} (default)
no adjustment is performed.}
}
\value{
If \code{format_output = FALSE}, a named list of test objects
keyed by "Outcome_Categorical".  If \code{format_output = TRUE}, a
data frame with columns \code{Outcome}, \code{Categorical}, \code{Comparison},
\code{Test}, \code{Estimate}, \code{Statistic}, and \code{P_value}.
}
\description{
\code{cyt_univariate} supports additional scaling options and explicit
choice of statistical test.
For each categorical predictor with exactly two levels and each
numeric outcome, a two‑sample t‑test or Wilcoxon rank–sum test is
performed.  Results are returned either as a list of test objects
or, if \code{format_output = TRUE}, as a tidy data frame with one
row per comparison.
}
\examples{
data_df <- ExampleData1[, -c(3)]
data_df <- dplyr::filter(data_df, Group != "ND", Treatment != "Unstimulated")
cyt_univariate(data_df[, c(1:2, 5:6)], scale = "log2",
               method = "auto", format_output = TRUE)
}
\author{
Shubh Saraswat
}
