% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lower_truncated_powerlaw.R
\name{bi.dist.lower_truncated_power_law}
\alias{bi.dist.lower_truncated_power_law}
\title{Lower Truncated Power Law Distribution}
\usage{
bi.dist.lower_truncated_power_law(
  alpha,
  low,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{alpha}{A numeric vector: index of the power law distribution. Must be less than -1.}

\item{low}{A numeric vector: lower bound of the distribution. Must be greater than 0.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector: Optional boolean array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector: A multi-purpose argument for shaping. When `sample=False` (model building), this is used
with `.expand(shape)` to set the distribution's batch shape. When `sample=True` (direct sampling), this is
used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{Integer: The number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{Logical: If `TRUE`, returns the raw BI distribution object instead of creating a sample site.
This is essential for building complex distributions like `MixtureSameFamily`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Lower Truncated Power Law distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Lower Truncated Power Law distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The *Lower-Truncated Power-Law* distribution (also known as the *Pareto Type I* or *power-law with a lower bound*)
 models quantities that follow a heavy-tailed power-law behavior but are bounded below by a minimum value
 \deqn{x_{\min}}. It is commonly used to describe phenomena such as wealth distributions, city sizes, and biological scaling laws.
}
\examples{
\donttest{
library(BayesianInference)
m <- importBI(platform = "cpu")
bi.dist.lower_truncated_power_law(alpha = c(-2, 2), low = c(1, 0.5), sample = TRUE)
}
}
\seealso{
This is a wrapper of  \url{https://num.pyro.ai/en/stable/distributions.html#lowertruncatedpowerlaw}
}
