% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{GOF}
\alias{GOF}
\alias{gof}
\alias{GOF.bsim}
\title{Goodness of Fit for \code{BayesSIM}}
\usage{
GOF(object)

\method{GOF}{bsim}(object, ...)
}
\arguments{
\item{object}{A fitted object of \code{BayesSIM} or individual model.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
Mean squared error of model with mean of MCMC sample is applied.
}
\description{
Generic function applied to \code{BayesSIM}.
It extracts goodness of fit of the \code{BayesSIM}.
}
\examples{
\donttest{
simdata2 <- data.frame(DATA1$X, y = DATA1$y)

# 1. One tool version
fit_one <- BayesSIM(y ~ ., data = simdata2,
                    niter = 5000, nburnin = 1000, nchain = 1)

# Check median index vector estimates with standard errors
coef(fit_one, method = "median", se = TRUE)

# Fitted index values of median prediction
fitted(fit_one, type = "linpred", method = "median")

# Residuals of median prediction
residuals(fit_one, method = "median")

# Summary of the model
summary(fit_one)

# Convergence diagnostics
nimTraceplot(fit_one)

# Goodness of fit
GOF(fit_one)

# Fitted plot
plot(fit_one)

# Prediction with 95\% credible interval at new data
newx <- data.frame(X1 = rnorm(10), X2 = rnorm(10), X3 = rnorm(10), X4 = rnorm(10))
pred <- predict(fit_one, newdata = newx, interval = "credible", level = 0.95)
plot(pred)


# 2. Split version
models <- BayesSIM_setup(y ~ ., data = simdata2)
Ccompile <- compileModelAndMCMC(models)
nimSampler <- get_sampler(Ccompile)
initList <- getInit(models)
mcmc.out <- runMCMC(nimSampler, niter = 5000, nburnin = 1000, thin = 1,
                    nchains = 1, setSeed = TRUE, inits = initList,
                    summary = TRUE, samplesAsCodaMCMC = TRUE)

# "fit_split" becomes exactly the same as the class of "fit_one" object and apply generic functions.
fit_split <- as_bsim(models, mcmc.out)

}
}
