% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BICAM.R
\name{BICAM}
\alias{BICAM}
\title{Bayesian Immune Cell Abundance Model (BICAM)}
\usage{
BICAM(
  dat,
  M,
  adapt,
  burn,
  it,
  thin = 1,
  ran_eff = 1,
  chains = 4,
  cores = 4,
  v0_mu_logit = 0.01,
  ncov = 1,
  model = "Unstr",
  dis = NULL,
  tree = NULL,
  treelevels = NULL
)
}
\arguments{
\item{dat}{data frame with dataset (proper setup displayed in tutorial)}

\item{M}{number of cell types/parameters of interest}

\item{adapt}{number of adaptation iterations (for compiling model)}

\item{burn}{number of burn-in iterations}

\item{it}{number of sampling iterations (after burn-in)}

\item{thin}{number of thinning samples}

\item{ran_eff}{indicate whether to use random subject effect (repeated measurements)}

\item{chains}{number of chains to run}

\item{cores}{number of cores}

\item{v0_mu_logit}{anticipated proportion of cell types/parameters}

\item{ncov}{number of covariates input into the model}

\item{model}{covariance model selection}

\item{dis}{distance matrix for Exp. Decay model}

\item{tree}{tree-structured covariance matrix for Tree and Scaled Tree models}

\item{treelevels}{list of matrices for multilevel, tree-structured covariance matrix for TreeLevels model}
}
\value{
A list of inputs and results
}
\description{
Bayesian Immune Cell Abundance Model (BICAM)
}
